<?php
/**
 * Tags
 *
 * @package     AutomatorWP\Restrict_Content_Pro\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Membership tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_restrict_content_pro_get_membership_tags() {

    return array(
        'membership_id' => array(
            'label'     => __( 'Membership ID', 'automatorwp-pro' ),
            'type'      => 'integer',
            'preview'   => '1',
        ),
        'membership_name' => array(
            'label'     => __( 'Membership name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => __( 'My membership', 'automatorwp-pro' ),
        ),
        'membership_initial_amount' => array(
            'label'     => __( 'Membership initial amount', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '10.00',
        ),
        'membership_recurring_amount' => array(
            'label'     => __( 'Membership recurring amount', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '10.00',
        ),
        'membership_start' => array(
            'label'     => __( 'Membership start date', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '01/01/2024',
        ),
        'membership_end' => array(
            'label'     => __( 'Membership end date', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => '01/01/2025',
        ),
    );

}

/**
 * Custom trigger membership tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_paid_restrict_content_pro_get_trigger_membership_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'restrict_content_pro' ) {
        return $replacement;
    }

    $membership_id = absint( automatorwp_get_log_meta( $log->id, 'membership_id', true ) );

    // Bail if not membership ID store
    if( $membership_id === 0 ) {
        return $replacement;
    }

    $membership_details = rcp_get_membership( $membership_id );

    if( ! $membership_details ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'membership_id':
            $replacement = $membership_id;
            break;
        case 'membership_name':
            $replacement = $membership_details->get_membership_level_name();
            break;
        case 'membership_initial_amount':
            $replacement = $membership_details->get_initial_amount();
            break;
        case 'membership_recurring_amount':
            $replacement = $membership_details->get_recurring_amount();
            break;
        case 'membership_start':
            $replacement = $membership_details->get_activated_date();
            break;
        case 'membership_end':
            $replacement = $membership_details->get_expiration_date();
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_paid_restrict_content_pro_get_trigger_membership_tag_replacement', 10, 6 );