(function ( $ ) {

    // Selector Control
    $('#cmb2-metabox-automatorwp-restrict-content .automatorwp-selector select').each(function() { automatorwp_selector( $(this) ); });

    // Selector Control
    $('#cmb2-metabox-automatorwp-restrict-content .automatorwp-ajax-selector select').each(function() { automatorwp_ajax_selector( $(this) ); });

    // Post Selector Control
    $('#cmb2-metabox-automatorwp-restrict-content .automatorwp-post-selector select').each(function() { automatorwp_post_selector( $(this) ); });

    var prefix = 'automatorwp-restrict-content';
    var _prefix = 'automatorwp_restrict_content';

    $('#_' + _prefix + '_restrict').on('change', function() {
        // All fields selector
        var selector = '.cmb2-id--' + prefix + '-required-roles, '
            + '.cmb2-id--' + prefix + '-required-access-levels, '
            + '.cmb2-id--' + prefix + '-restriction, '
            + '.cmb2-id--' + prefix + '-redirect-page, '
            + '.cmb2-id--' + prefix + '-redirect-url, '
            + '.cmb2-id--' + prefix + '-content-replacement';

        if( $(this).prop('checked') ) {
            // Selector when enabled
            selector = '.cmb2-id--' + prefix + '-required-roles, '
                + '.cmb2-id--' + prefix + '-required-access-levels, '
                + '.cmb2-id--' + prefix + '-restriction';

            // Trigger change on restriction select
            $('#_' + _prefix + '_restriction').trigger('change');

            $(selector).slideDown('fast');
        } else {
            $(selector).slideUp('fast');
        }
    });

    if( ! $('#_' + _prefix + '_restrict').prop('checked') ) {
        $( '.cmb2-id--' + prefix + '-required-roles, '
            + '.cmb2-id--' + prefix + '-required-access-levels, '
            + '.cmb2-id--' + prefix + '-restriction, '
            + '.cmb2-id--' + prefix + '-redirect-page, '
            + '.cmb2-id--' + prefix + '-redirect-url, '
            + '.cmb2-id--' + prefix + '-content-replacement'
        ).hide();
    }

    $('#_' + _prefix + '_restriction').on('change', function() {

        if( ! $('#_' + _prefix + '_restrict').prop('checked') ) {
            return;
        }

        var value = $(this).val();

        // All fields selector
        var hide = '.cmb2-id--' + prefix + '-redirect-page, '
            + '.cmb2-id--' + prefix + '-redirect-url, '
            + '.cmb2-id--' + prefix + '-content-replacement';

        var show = '';

        if( value === 'redirect_page' ) {

            show = '.cmb2-id--' + prefix + '-redirect-page';

            hide = '.cmb2-id--' + prefix + '-redirect-url, '
                + '.cmb2-id--' + prefix + '-content-replacement';

        } else if( value === 'redirect_url' ) {

            show = '.cmb2-id--' + prefix + '-redirect-url';

            hide = '.cmb2-id--' + prefix + '-redirect-page, '
                + '.cmb2-id--' + prefix + '-content-replacement';

        } else if( value === 'content_replacement' ) {

            show = '.cmb2-id--' + prefix + '-content-replacement';

            hide = '.cmb2-id--' + prefix + '-redirect-page, '
                + '.cmb2-id--' + prefix + '-redirect-url';

        }

        $(show).slideDown('fast');
        $(hide).slideUp('fast');
    });

    // Trigger change on restriction select
    $('#_' + _prefix + '_restriction').trigger('change');

    // On add a new group row, reinitialize selectors
    $('body').on('cmb2_add_row', '#automatorwp-restrict-content .cmb-repeatable-group', function( e, row, cmb ) {

        // Remove Select2 element
        row.find('.select2').remove();

        // Find all Select2 elements
        var select2_elements = row.find('.select2-hidden-accessible');

        // Reset Select2 data on options
        select2_elements.find('optgroup, option')
            .removeAttr('id')
            .removeAttr('data-select2-id'); // For options and group options, select2 assigns this attribute as id

        // Reset Select2 data on the input element
        select2_elements
            .removeClass('select2-hidden-accessible')
            .removeAttr('id')
            .removeAttr('data-select2-id'); // For fields without id, select2 assigns this attribute as id

        // Selector Control
        row.find('.automatorwp-selector select').each(function() { automatorwp_selector( $(this) ); });

        // Selector Control
        row.find('.automatorwp-ajax-selector select').each(function() { automatorwp_ajax_selector( $(this) ); });

        // Post Selector Control
        row.find('.automatorwp-post-selector select').each(function() { automatorwp_post_selector( $(this) ); });
    });

})( jQuery );