<?php
/**
 * Meta Boxes
 *
 * @package     AutomatorWP\Restrict_Content\Meta_Boxes
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

function automatorwp_restrict_content_meta_boxes() {

    $prefix = '_automatorwp_restrict_content_';

    $post_types = automatorwp_restrict_content_post_types_slugs();

    $fields = array();

    // Restrict fields
    $fields = array_merge($fields, array(
        $prefix . 'restrict' => array(
            'desc' => __( 'User must be logged in to view this post.', 'automatorwp-pro' ),
            'type' => 'checkbox',
            'classes' => 'automatorwp-switch',
        ),
        $prefix . 'required_roles' => array(
            'name'          => __( 'Required Roles (Optional)', 'automatorwp-pro' ),
            'type'          => 'automatorwp_select',
            'classes' 	    => 'automatorwp-selector',
            'options_cb'    => 'automatorwp_restrict_content_get_roles_options',
            'attributes' 	    => array(
                'multiple' => true,
                'data-placeholder' => __( 'Select the user roles', 'automatorwp-pro' ),
            ),
            'default'           => '',
        ),
        $prefix . 'required_access_levels' => automatorwp_utilities_ajax_selector_field( array(
            'name'              => __( 'Required Access Levels (Optional)', 'automatorwp-pro' ),
            'option_none'       => true,
            'multiple'          => true,
            'action_cb'         => 'automatorwp_restrict_content_get_access_levels',
            'options_cb'        => 'automatorwp_restrict_content_options_cb_access_level',
            'placeholder'       => __( 'Select the access levels', 'automatorwp-pro' ),
            'default'           => '',
        ) ),
    ));

    /**
     * Filter to add custom fields after the restrict section
     *
     * @since 1.0.0
     *
     * @param array $fields Post meta box fields
     *
     * @return array
     */
    $fields = apply_filters( 'automatorwp_restrict_content_post_restrict_fields', $fields );

    // Restriction fields
    $fields = array_merge($fields, array(
        $prefix . 'restriction' => array(
            'name' => __( 'Restriction to apply', 'automatorwp-pro' ),
            'type' => 'advanced_select',
            'classes' 	    => 'automatorwp-selector',
            'options' => array(
                '' => __( 'Select a restriction', 'automatorwp-pro' ),
                'redirect_page' => __( 'Redirect to page', 'automatorwp-pro' ),
                'redirect_url' => __( 'Redirect to   URL', 'automatorwp-pro' ),
                'content_replacement' => __( 'Replace post content', 'automatorwp-pro' ),
            ),
            'attributes' => array(
                'data-placeholder' => __( 'Select a restriction', 'automatorwp-pro' ),
            ),
            'default' => '',
        ),

        $prefix . 'redirect_page' => array(
            'name' => __( 'Redirect Page', 'automatorwp-pro' ),
            'type' => 'select',
            'classes' 	        => 'automatorwp-post-selector',
            'attributes' 	    => array(
                'data-post-type' => implode( ',',  automatorwp_restrict_content_redirect_post_types_slugs() ),
                'data-placeholder' => __( 'WordPress error page', 'automatorwp-pro' ),
            ),
            'default'           => '',
            'options_cb'        => 'automatorwp_options_cb_posts'
        ),
        $prefix . 'redirect_url' => array(
            'name' => __( 'Redirect URL', 'automatorwp-pro' ),
            'type' => 'text',
        ),
        $prefix . 'content_replacement' => array(
            'name' => __( 'Content Replacement', 'automatorwp-pro' ),
            'type' => 'wysiwyg',
        ),
    ));

    /**
     * Filter to add custom fields after the restriction section
     *
     * @since 1.0.0
     *
     * @param array $fields Post meta box fields
     *
     * @return array
     */
    $fields = apply_filters( 'automatorwp_restrict_content_post_restriction_fields', $fields );

    // Adds the meta box
    automatorwp_add_meta_box(
        'automatorwp-pro',
        __( 'AutomatorWP - Restrict Content', 'automatorwp-pro' ),
        $post_types,
        $fields,
        array(
            'context' => 'side',
        )
    );

}
add_action( 'cmb2_admin_init', 'automatorwp_restrict_content_meta_boxes' );