<?php
/**
 * Plugin Name:           AutomatorWP - Sensei LMS
 * Plugin URI:            https://automatorwp.com/add-ons/sensei-lms/
 * Description:           Connect AutomatorWP with Sensei LMS.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-sensei-lms
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Sensei_LMS
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Sensei_LMS {

    /**
     * @var         AutomatorWP_Sensei_LMS $instance The one true AutomatorWP_Sensei_LMS
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Sensei_LMS self::$instance The one true AutomatorWP_Sensei_LMS
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Sensei_LMS();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_SENSEI_LMS_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_SENSEI_LMS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_SENSEI_LMS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_SENSEI_LMS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/triggers/complete-quiz.php';
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/triggers/complete-quiz-percentage.php';
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/triggers/complete-lesson.php';
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/triggers/enroll-course.php';
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/triggers/complete-course.php';

            // Actions
            require_once AUTOMATORWP_SENSEI_LMS_DIR . 'includes/actions/user-course.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'sensei_lms', array(
            'label' => 'Sensei LMS',
            'icon'  => AUTOMATORWP_SENSEI_LMS_URL . 'assets/sensei-lms.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'Sensei_Main' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Sensei_LMS instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Sensei_LMS The one true AutomatorWP_Sensei_LMS
 */
function AutomatorWP_Sensei_LMS() {
    return AutomatorWP_Sensei_LMS::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Sensei_LMS' );
