<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Twilio\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_twilio_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-twilio-css', AUTOMATORWP_TWILIO_URL . 'assets/css/automatorwp-twilio' . $suffix . '.css', array(), AUTOMATORWP_TWILIO_VER, 'all' );

}
add_action( 'admin_init', 'automatorwp_twilio_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_twilio_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-twilio-css' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_twilio_admin_enqueue_scripts', 100 );