<?php
/**
 * Create Survey
 *
 * @package     AutomatorWP\Integrations\UserFeedback\Actions\Create_Survey
 * @author      AutomatorWP <survey@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_UserFeedback_Create_Survey extends AutomatorWP_Integration_Action {

    public $integration = 'userfeedback';
    public $action = 'userfeedback_create_survey';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create a new survey', 'automatorwp-pro' ),
            'select_option'     => __( 'Create a <strong>new survey</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: List. */
            'edit_label'        => sprintf( __( 'Create a new %1$s', 'automatorwp-pro' ), '{survey}' ),
            /* translators: %1$s: List. */
            'log_label'         => sprintf( __( 'Create a new %1$s', 'automatorwp-pro' ), '{survey}' ),
            'options'           => array(
                'survey' => array(
                    'from' => 'survey',
                    'default' => __('survey', 'automatorwp-pro'),
                    'fields' => array(
                        'survey_title' => array(
                            'name' => __( 'Title: ', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => '',
                            'required'  => true
                        ),
                        'survey_type' => array(
                            'name' => __( 'Type: ', 'automatorwp-pro' ),
                            'type' => 'select',
                            'option_none' => false,
                            'options_cb' => 'automatorwp_userfeedback_survey_get_all_type_options_cb',
                            'required'  => true
                        ),
                        'survey_question' => array(
                            'name' => __( 'Question: ', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => 'What can we do to improve this website?',
                            'required'  => true
                        )
                    )
                ),
            ),
   ));


    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $args = automatorwp_userfeedback_args_formatter($action_options);
        $this->result = '';
       
        $survey = new UserFeedback_Surveys();        
		$new_id = UserFeedback_Survey::create( $args );

        $this->result = __( 'Survey added to UserFeedback', 'automatorwp-pro' );

    }

    

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_UserFeedback_Create_Survey();