<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\WP_Courseware\Includes\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get modules from WP Courseware
 *
 * @since 1.0.0
 * 
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_wpcw_options_cb_module( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any module', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );
    
    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $module_id ) {

            // Skip option none
            if( $module_id === $none_value ) {
                continue;
            }
            
            $options[$module_id] = automatorwp_wpcw_get_module_name( $module_id );
        }
    }

    return $options;

}

/**
 * Get WP Courseware modules
 *
 * @since 1.0.0
 *
 * @return array|false
 */
function automatorwp_wpcw_get_modules() {

    global $wpdb;
    $modules = array( );

    $results = $wpdb->get_results( "SELECT module_id, module_title FROM {$wpdb->prefix}wpcw_modules" );

    foreach ( $results as $module ){   

        $modules[] = array(
            'id'    => $module->module_id,
            'title'  => $module->module_title,
        );         

    }

    return $modules;

}

/**
 * Get WP Courseware module name
 *
 * @since 1.0.0
 *
 * @param int    $module_id         ID module
 * 
 */
function automatorwp_wpcw_get_module_name( $module_id ) {

    global $wpdb;

    $module_name = $wpdb->get_var( $wpdb->prepare(
        "SELECT m.module_title FROM {$wpdb->prefix}wpcw_modules AS m WHERE m.module_id = %d",
        absint( $module_id )
    ) );
    
    return $module_name;

}