<?php
/**
 * Track Event
 *
 * @package     AutomatorWP\Integrations\WP_Fusion\Actions\Track_Event
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_Fusion_Track_Event extends AutomatorWP_Integration_Action {

    public $integration = 'wp_fusion';
    public $action = 'wp_fusion_track_event';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Track an event', 'automatorwp-pro' ),
            'select_option'     => __( 'Track <strong>an event</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Event. */
            'edit_label'        => sprintf( __( 'Track %1$s', 'automatorwp-pro' ), '{event}' ),
            /* translators: %1$s: Event. */
            'log_label'         => sprintf( __( 'Track %1$s', 'automatorwp-pro' ), '{event}' ),
            'options'           => array(
                'event' => array(
                    'default' => __( 'an event', 'automatorwp-pro' ),
                    'fields' => array(
                        'event_name' => array(
                            'name' => __( 'Name:', 'automatorwp-pro' ),
                            'desc' => __( 'The event name.', 'automatorwp-pro'),
                            'type' => 'text',
                            'required' => true,
                            'default' => ''
                        ),                    
                        'event_value' => array(
                            'name' => __( 'Description:', 'automatorwp-pro' ),
                            'desc' => __( 'Description to be registered with the event.', 'automatorwp-pro'),
                            'type' => 'text',
                            'required' => false,
                            'default' => ''
                        ),
                        'event_email' => array(
                            'name' => __( 'Email:', 'automatorwp-pro' ),
                            'desc' => __( 'Account where the event will be tracked.', 'automatorwp-pro')
                                . ' ' . __('Leave empty to use the ID of the user that completes the automation.', 'automatorwp'),
                            'type' => 'text',
                            'required' => false,
                            'default' => ''
                        ),
                    ),
                    
                )
            ),
        ) 
    );

    }

 

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        $event_name = $action_options['event_name'];
        $event_value = $action_options['event_value'];
        $event_email = $action_options['event_email'];

        // Bail if not event name
        if ( empty ( $event_name ) ){
            return;
        }

        // If the option is empty, gets the email from the trigger
        if ( empty( $event_email ) ){
            $user = get_userdata( $user_id );

            $event_email = $user->user_email;
        }

        // Send the event to crm to be tracked
        wp_fusion()->crm->track_event( $event_name, $event_value, $event_email );
    }

}

new AutomatorWP_WP_Fusion_Track_Event();