<?php
/**
 * Remove User Group
 *
 * @package     AutomatorWP\Integrations\WP_User_Manager\Actions\Remove_User_Group
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_User_Manager_Remove_User_Group extends AutomatorWP_Integration_Action {

    public $integration = 'wp_user_manager';
    public $action = 'wp_user_manager_remove_user_group';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Remove user from group', 'automatorwp-pro' ),
            'select_option'     => __( 'Remove user from <strong>group</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Group. */
            'edit_label'        => sprintf( __( 'Remove user from %1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Group. */
            'log_label'         => sprintf( __( 'Remove user from %1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Group:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all groups', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Group ID', 'automatorwp-pro' ),
                    'post_type'         => 'wpum_group'
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $group_id = $action_options['post'];
        $groups = array();

        if( ! function_exists( 'wpumgp_leave_group' ) ) {
            return;
        }

        if( $group_id === 'any' ) {

            // Get all user groups
            $db = new WPUMG_DB_Group_Users;
            $groups = $db->get_groups_by( $user_id );

            if( is_array( $groups ) && count( $groups ) ) {
                $groups = wp_list_pluck( $groups, 'group_id');
            }

        } else {

            // Bail if group not provided
            if( absint( $group_id ) === 0 ) {
                return;
            }

            $groups = array( $group_id );
        }

        // Remove the user from groups
        foreach( $groups as $group_id ) {
            do_action( 'wpumgp_user_leave_group', $group_id, $user_id );
        }

    }

}

new AutomatorWP_WP_User_Manager_Remove_User_Group();