<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Youtube\Scripts
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_youtube_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Scripts
    wp_register_script( 'automatorwp-youtube-api-js', 'https://www.youtube.com/iframe_api', array( 'jquery' ), AUTOMATORWP_YOUTUBE_VER, true );
    wp_register_script( 'automatorwp-youtube-js', AUTOMATORWP_YOUTUBE_URL . 'assets/js/automatorwp-youtube' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_YOUTUBE_VER, true );

}
add_action( 'init', 'automatorwp_youtube_register_scripts' );

/**
 * Enqueue frontend scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_youtube_enqueue_scripts( $hook = null ) {

    /**
     * Allowed delay in seconds to allow set the video as watched
     * This delay is added as extra watched seconds to avoid delay issues caused, for example, by the browser or javascript slowdowns
     * A delay of 1 sec will make event get triggered if users see 9 secs of a 10 secs video
     *
     * @since 1.0.0
     *
     * @param int $allowed_delay    Allowed delay in seconds, by default 1
     *
     * @return int                  Allowed delay in seconds
     */
    $allowed_delay = apply_filters( 'automatorwp_youtube_allowed_delay', 1 );

    // Scripts
    wp_localize_script( 'automatorwp-youtube-js', 'automatorwp_youtube', array(
        'ajaxurl'       => esc_url( admin_url( 'admin-ajax.php', 'relative' ) ),
        'nonce'         => wp_create_nonce( 'automatorwp_youtube' ),
        'user_id'       => get_current_user_id(),
        'post_id'       => get_the_ID(),
        'allowed_delay' => $allowed_delay
    ) );

    wp_enqueue_script( 'automatorwp-youtube-api-js' );
    wp_enqueue_script( 'automatorwp-youtube-js' );

}
add_action( 'wp_enqueue_scripts', 'automatorwp_youtube_enqueue_scripts', 100 );