import {BackgroundSelectorConfig} from '@common/background-selector/background-selector-config';
import {message} from '@ui/i18n/message';

export const BaseImageBg: BackgroundSelectorConfig = {
  type: 'image',
  id: 'i-custom',
  label: message('Custom image'),
};

export const ImageBackgrounds: BackgroundSelectorConfig[] = [
  {
    ...BaseImageBg,
    id: 'img0',
    backgroundColor: '#ee5522',
    backgroundImage: `url(images/svg-bgs/Protruding-Squares.svg)`,
    backgroundRepeat: 'repeat',
    label: message('Protruding squares'),
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img1',
    backgroundColor: '#00bbff',
    backgroundImage: `url(images/svg-bgs/Launch-Day.svg)`,
    label: message('Launch day'),
    backgroundSize: 'contain',
    backgroundPosition: 'bottom',
    backgroundRepeat: 'no-repeat',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img2',
    backgroundColor: '#fff',
    backgroundImage: `url(images/svg-bgs/Alternating-Triangles.svg)`,
    label: message('Alternating triangles'),
    color: '#000',
  },
  {
    ...BaseImageBg,
    id: 'img3',
    backgroundColor: '#002200',
    backgroundImage: `url(images/svg-bgs/Monstera-Patch.svg)`,
    label: message('Monstera patch'),
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img4',
    backgroundColor: '#aa3333',
    backgroundImage: `url(images/svg-bgs/Confetti-Doodles.svg)`,
    label: message('Confetti doodles'),
    color: '#fff',
    backgroundRepeat: 'repeat',
    backgroundPosition: 'center center',
    backgroundSize: 'contain',
  },
  {
    ...BaseImageBg,
    id: 'img5',
    backgroundColor: '#070014',
    backgroundImage: `url(images/svg-bgs/Hurricane-Aperture.svg)`,
    label: message('Hurricane aperture'),
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'center center',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img6',
    backgroundColor: '#11ddaa',
    backgroundImage: `url(images/svg-bgs/Looney-Loops.svg)`,
    label: message('Looney loops'),
    backgroundPosition: 'center center',
    backgroundSize: 'cover',
    color: '#000',
  },
  {
    ...BaseImageBg,
    id: 'img7',
    backgroundColor: '#ccffff',
    backgroundImage: `url(images/svg-bgs/Icy-Explosion.svg)`,
    label: message('Icy explosion'),
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'center center',
    color: '#000',
  },
  {
    ...BaseImageBg,
    id: 'img8',
    backgroundColor: '#442233',
    backgroundImage: `url(images/svg-bgs/Nuclear-Focalpoint.svg)`,
    label: message('Nuclear point'),
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    backgroundPosition: 'center center',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img9',
    backgroundColor: '#ffdd55',
    backgroundImage: `url(images/svg-bgs/Angled-Focus.svg)`,
    label: message('Angled focus'),
    backgroundPosition: 'center center',
    backgroundSize: 'cover',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img10',
    backgroundColor: '#220044',
    backgroundImage: `url(images/svg-bgs/Circular-Focus.svg)`,
    label: message('Circular focus'),
    backgroundPosition: 'center center',
    backgroundSize: 'cover',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img11',
    backgroundColor: '#000000',
    backgroundImage: `url(images/svg-bgs/Farseeing-Eyeball.svg)`,
    label: message('Farseeing eyeball'),
    backgroundPosition: 'center center',
    backgroundSize: 'cover',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img12',
    backgroundColor: '#ff0000',
    backgroundImage: `url(images/svg-bgs/Canyon-Funnel.svg)`,
    label: message('Canyon funnel'),
    backgroundPosition: 'center center',
    backgroundSize: 'cover',
    color: '#fff',
  },
  {
    ...BaseImageBg,
    id: 'img13',
    backgroundColor: '#ffdd99',
    backgroundImage: `url(images/svg-bgs/Threads-Ahead.svg)`,
    label: message('Threads ahead'),
    color: '#000',
    backgroundRepeat: 'no-repeat',
    backgroundSize: 'auto',
  },
  {
    ...BaseImageBg,
    id: 'img14',
    backgroundImage: `url(images/svg-bgs/Sprinkle.svg)`,
    label: message('Sprinkle'),
    backgroundRepeat: 'repeat',
    backgroundPosition: 'center center',
  },
  {
    ...BaseImageBg,
    id: 'img15',
    backgroundImage: `url(images/svg-bgs/Circuit-Board.svg)`,
    label: message('Circuit board'),
    backgroundRepeat: 'repeat',
    backgroundPosition: 'center center',
  },
  {
    ...BaseImageBg,
    id: 'img16',
    backgroundImage: `url(images/svg-bgs/Snow.svg)`,
    label: message('Snow'),
    backgroundRepeat: 'repeat',
    backgroundPosition: 'center center',
  },
];
