<?php
namespace BetterLinksPro\Admin;

use BetterLinksPro\Helper;
use BetterLinksPro\Link;

class Actions {
	public static function init() {
		$self = new self();
		$self->define_actions();
		$self->define_filters();
	}

	public function define_actions() {
		add_action( 'betterlinkspro/admin/check_password_protection', array( $this, 'check_password_protection' ), 10, 2 );
		add_action( 'betterlinkspro/admin/update_link', array( $this, 'update_link' ), 10, 2 );
	}

	public function define_filters() {
		add_filter( 'betterlinkspro/admin/update_settings', array( $this, 'update_settings' ) );
		add_filter( 'betterlinkspro/admin/split_test_tracking', array( $this, 'split_test_tracking' ), 10, 2 );
		add_filter( 'betterlinks/extra_tracking_data', array( $this, 'device_data_collect' ), 10, 2 );
		add_filter( 'betterlinkspro/get_individual_graph_data', array($this, 'get_individual_graph_data'), 10, 4 );
		add_filter( 'betterlinkspro/admin/parameter_tracking_values', array( $this, 'parameter_tracking_values' ), 10, 2 );
	}

	public function split_test_tracking( $is_split_enabled, $data ) {
		$helper = new \BetterLinks\Helper();

		$split_test_data  = Helper::split_test_enabled( $data );
		$is_split_enabled = isset( $split_test_data['result'] ) ? $split_test_data['result'] : $is_split_enabled;

		if ( ! $is_split_enabled && ! empty( $split_test_data['completed'] ) ) {
			if ( ! $helper::get_link_meta( $data['ID'], 'split_test_data' ) ) {
				$helper::add_link_meta( $data['ID'], 'split_test_data', $split_test_data );
			}

			if ( ! $helper::get_link_meta( $data['ID'], 'split_test_analytics' ) ) {
				$split_analytics = Helper::get_split_test_analytics_data( array( 'id' => $data['ID'] ) );
				$helper::add_link_meta( $data['ID'], 'split_test_analytics', $split_analytics );
			}
		}

		return $is_split_enabled;
	}

	public function check_password_protection( $request_uri, $data ) {
		if ( apply_filters( 'betterlinks/is_password_protected_redirect_compatible', false ) ) { // phpcs:ignore.
			// fetch settings to check password protected redirect is enable or not.
			$cache = new \BetterLinks\Admin\Cache();
			// $utils = new \BetterLinks\Link\Utils;
			$settings = $cache::get_json_settings();

			if ( ! empty( $settings['enable_password_protection'] ) ) {
				$pro_helper        = new Helper();
				$referer           = isset( $_SERVER['HTTP_REFERER'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_REFERER'] ) ) : null;
				$request_uri       = site_url( '/' ) . $request_uri;
				$short_url         = $pro_helper->get_protected_self_url_short_link( $request_uri );
				$referer_short_url = $pro_helper->referer_short_url( $referer );

				// if request are coming from password protected form and password is okk.
				if ( $referer_short_url === $short_url ) {
					return false;
				}

				$id = isset( $data['ID'] ) ? $data['ID'] : null;
				if ( empty( $id ) ) {
					return false;
				}
				$password_protection_status = Link::get_password_protection_status();
				$is_active_cookie           = $pro_helper->passsword_cookie_enabled( $password_protection_status['remember_password_cookies'], $id );
				if ( $is_active_cookie ) {
					return false;
				}
			}
		}
	}
	public function update_settings( $response ) {
		$enable_password_protection = ! empty( $response['enable_password_protection'] ) ? $response['enable_password_protection'] : false;
		$enable_customize_meta_tag  = ! empty( $response['enable_customize_meta_tags'] ) ? $response['enable_customize_meta_tags'] : false;

		if ( class_exists( '\BetterLinksPro\Helper' ) ) {
			$pro_helper = new Helper();
			if ( $enable_password_protection ) {
				$pro_helper->add_password_protect_page();
			} else {
				$pro_helper->delete_custom_page( 'password-protected-form' );
			}

			if ( $enable_customize_meta_tag ) {
				$pro_helper->add_customized_meta_tag_page();
			} else {
				$pro_helper->delete_custom_page( 'customized-meta-tags' );
			}

			if ( ! empty( $response['cle']['enable_cle'] ) ) {
				$category                    = ! empty( $response['cle']['category'] ) ? sanitize_text_field( $response['cle']['category'] ) : 1;
				$category                    = \BetterLinks\Helper::insert_new_category( $category );
				$response['cle']['category'] = $category;
			}
		}

		return $response;
	}

	public function device_data_collect( $data, $dd ) {
		if ( ! apply_filters( 'betterlinks/is_extra_data_tracking_compatible', false ) ) {
			return $data;
		}

		$client_info = $dd->getClient();
		$os_details  = $dd->getOs();

		$language = isset( $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) ? sanitize_text_field( $_SERVER['HTTP_ACCEPT_LANGUAGE'] ) : 'en-US,en;q=0.5';
		$language = explode( ',', $language )[0];

		$client_information_arr = array(
			'brand_name'      => $dd->getBrandName(),
			'model'           => $dd->getModel(),
			'bot_name'        => $dd->isBot() ? $dd->getBot()['name'] : null,
			'browser_type'    => isset( $client_info['type'] ) ? $client_info['type'] : null,
			'browser_version' => isset( $client_info['version'] ) ? $client_info['version'] : null,
			'os_version'      => isset( $os_details['version'] ) ? $os_details['version'] : null,
			'language'        => ! empty( $language ) ? $language : 'en-US',
		);

		return array_merge( $data, $client_information_arr );
	}

	public function get_individual_graph_data( $graph_data, $id, $from, $to ) {
		if ( ! apply_filters( 'betterlinks/is_extra_data_tracking_compatible', false ) ) {
			return $graph_data;
		}
		return Helper::get_individual_graph_data( $id, $from, $to );
	}

	public function update_link( $id, $arg ) {
		Helper::update_custom_script_data( $id, $arg );
	}

	public function parameter_tracking_values( $values, $data ) {
		global $betterlinks;
		if( ! filter_var( $data['track_me'], FILTER_VALIDATE_BOOLEAN ) ){
			return $values;
		}
		$pts = ! empty( $betterlinks['parameter_tracking'] ) ? $betterlinks['parameter_tracking'] : false;
		if ( empty( $pts ) ) {
			return $values;
		}

		if ( ! empty( $data['pf'] ) && ! empty( $pts['pf'] ) ) {
			$values['pf'] = $data['pf'];
		}

		if ( empty( $pts['target_url'] ) && empty( $pts['utm'] ) ) {
			return $values;
		}

		$target_url        = $data['target_url'];
		$target_url_params = wp_parse_url( $target_url );
		$target_url_params = isset( $target_url_params['query'] ) ? $target_url_params['query'] : '';

		if ( empty( $target_url_params ) ) {
			return $values;
		}

		$target_url_params = explode( '&', $target_url_params );

		$utm_params = array();

		foreach ( $target_url_params as $key => $value ) {
			if ( strpos( $value, 'utm_' ) === 0 ) {
				array_push( $utm_params, $value );
				unset( $target_url_params[ $key ] );
				continue;
			}
		}

		if ( ! empty( $target_url_params ) && ! empty( $pts['target_url'] ) ) {
			$target_url_params    = implode( '&', $target_url_params );
			$values['target_url'] = $target_url_params;
		}
		if ( ! empty( $utm_params ) && ! empty( $pts['utm'] ) ) {
			$utm_params    = implode( '&', $utm_params );
			$values['utm'] = $utm_params;
		}
		return $values;
	}
}
