<?php
/**
 * @since 1.8.0
 * @package Cutomize Meta Preview
 *
 * Template Name: Customize Meta Tags
 * Template Post Type: page
 */

if ( ! defined( 'ABSPATH' ) ) {
	wp_die( 'You are forbidden to visit this page.' );
}

$short_url = ! empty( $_GET['short_url'] ) ? sanitize_text_field( wp_unslash( $_GET['short_url'] ) ) : null;
if ( empty( $short_url ) ) {
	wp_safe_redirect( site_url() . '/404' );
	exit();
}
$meta_tags = \BetterLinksPro\Helper::get_meta_tags_by_short_url( $short_url );

$meta_title = isset( $meta_tags['meta_title'] ) ? sanitize_text_field( $meta_tags['meta_title'] ) : '';
$meta_desc  = isset( $meta_tags['meta_desc'] ) ? sanitize_text_field( $meta_tags['meta_desc'] ) : '';
$meta_image = isset( $meta_tags['meta_image'] ) ? sanitize_url( $meta_tags['meta_image'] ) : '';
$meta_url   = isset( $meta_tags['meta_url'] ) ? sanitize_url( $meta_tags['meta_url'] ) : '';
?>
<!DOCTYPE html>
<html lang="en">

<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta property="og:type" content="article" />

	<meta property="og:title" content="<?php esc_attr_e( $meta_title, 'betterlinks-pro' ); ?>">
	<meta property="og:description" content="<?php esc_attr_e( $meta_desc, 'betterlinks-pro' ); ?>">
	<meta property="og:image" content="<?php echo esc_url( $meta_image ); ?>">
	<!-- <meta property="og:url" content="<?php // echo esc_url( $meta_url ); ?>"> -->

	<!-- Twitter Card Tags (Optional) -->
	<meta name="twitter:card" content="summary_large_image">
	<meta name="twitter:title" content="<?php esc_attr_e( $meta_title, 'betterlinks-pro' ); ?>">
	<meta name="twitter:description" content="<?php esc_attr_e( $meta_desc, 'betterlinks-pro' ); ?>">
	<meta name="twitter:image" content="<?php echo esc_url( $meta_image ); ?>">
	<meta name="twitter:player" content="<?php echo esc_url( $meta_url ); ?>">

	<title><?php esc_html_e( $meta_title, 'betterlinks-pro' ); ?></title>
</head>

<body>
	<h1><?php esc_html_e( $meta_title, 'betterlinks-pro' ); ?></h1>
	<img src="<?php echo esc_url( $meta_image ); ?>" alt="<?php esc_attr_e( $meta_title, 'betterlinks-pro' ); ?>" />
	<p><?php esc_html_e( $meta_desc, 'betterlinks-pro' ); ?></p>
</body>

</html>			