<?php
	/*
	* Template Name: Password Protection Template
	* Template Post Type: page
	*/

if ( ! defined( 'ABSPATH' ) ) {
	wp_die( 'You are forbidden to visit this page.' );
}

    $short_url = !empty( $_GET['short_url'] ) ? sanitize_text_field( $_GET['short_url'] ) : null; // phpcs:ignore

if ( ! $short_url ) {
	wp_safe_redirect( site_url() . '/404' );
	exit();
}

if ( defined( 'BETTERLINKS_ASSETS_URI' ) ) {
	wp_enqueue_style( 'betterlinks-quil-editor', BETTERLINKS_ASSETS_URI . 'css/ql-editor.css', false );
}
	wp_enqueue_style( 'betterlinks-password-form', BETTERLINKS_PRO_ASSETS_URI . 'css/betterlinks-pass-protected-form.css', false );


	$error_message                  = '';
	$is_visitor_allowed_for_contact = 0;
	$allow_contact_text             = '';

	// 👇 fetching specific link information
	$Utils = new BetterLinks\Link\Utils();
	$data  = $Utils->get_slug_raw( $short_url );
	$ID    = isset( $data['ID'] ) ? $data['ID'] : null;

if ( ! $ID ) {
	wp_redirect( site_url() . '/404' );
	exit();
}

if ( empty( $data['target_url'] ) || ! apply_filters( 'betterlinks/pre_before_redirect', $data ) ) {
	return false;
}
	$data = apply_filters( 'betterlinks/link/before_dispatch_redirect', $data );


	$form_title         = '';
	$show_protected_url = 0;
	$button_text        = 'Submit';
	$button_bg_color    = '';
	$form_template      = 'one';

if ( class_exists( '\BetterLinksPro\Link' ) ) {
	$password_protection_status = \BetterLinksPro\Link::get_password_protection_status();


	if ( ! empty( $password_protection_status['enable_advanced_password_form_style'] ) ) {
		if ( ! empty( $password_protection_status['allow_visitor_contact'] ) ) {
			$is_visitor_allowed_for_contact = \BetterLinksPro\Helper::check_is_visitor_allowed_in_password_protection( $ID );
			$allow_contact_text             = isset( $password_protection_status['allow_contact_text'] ) ? $password_protection_status['allow_contact_text'] : '';
		}

		$form_title         = ( ! empty( $password_protection_status['enable_form_title'] ) && ! empty( $password_protection_status['form_title'] ) ) ? $password_protection_status['form_title'] : '';
		$show_protected_url = ! empty( $password_protection_status['show_protected_url'] ) ? 1 === (int) $password_protection_status['show_protected_url'] : 0;
		$button_text        = ( ! empty( $password_protection_status['button_text'] ) ) ? sanitize_text_field( $password_protection_status['button_text'] ) : 'Submit';
		$button_bg_color    = ( ! empty( $password_protection_status['button_bg_color'] ) ) ? sanitize_text_field( $password_protection_status['button_bg_color'] ) : '';
		$form_template      = ( ! empty( $password_protection_status['form_template'] ) ) ? sanitize_text_field( $password_protection_status['form_template'] ) : 'one';
	}

	$remember_password_cookies = isset( $password_protection_status['remember_password_cookies'] ) ? $password_protection_status['remember_password_cookies'] : false;
	$is_active_cookies         = (new \BetterLinksPro\Helper)->passsword_cookie_enabled( $remember_password_cookies, $ID );
	// $is_active_cookies returns true if the password is okay and cookie is already set.
	if ( $is_active_cookies ) {
		$Utils->dispatch_redirect( $data, $short_url );
		return;
	}
}

if ( isset( $_SERVER['REQUEST_METHOD'] ) && 'POST' === $_SERVER['REQUEST_METHOD'] ) {
	$password = isset( $_POST['password'] ) ? sanitize_text_field($_POST['password']) : ''; // phpcs:ignore

	if ( class_exists( '\BetterLinksPro\Helper' ) ) {
		$result = \BetterLinksPro\Helper::check_password( $password, $ID );

		if ( $result ) {
			// 👇 set cookies
			if ( ! empty( $password_protection_status['remember_password_cookies'] ) ) {
				$cookie_name            = "betterlinks_pass_protect_{$ID}";
				$cookie_expiration_time = isset( $password_protection_status['cookie_expiration_time'] ) ? (int) $password_protection_status['cookie_expiration_time'] : 0;
				$cookie_value           = $password;
				setcookie($cookie_name, $cookie_value, time() + $cookie_expiration_time, "/"); // phpcs:ignore
			}

			$Utils->dispatch_redirect( $data, $short_url );
		} else {
			$error_message = esc_html__( 'Password doesn\'t match.', 'betterlinks-pro' );
		}
	}
}


?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php wp_head(); ?>
	<style>
		.password-protection-form-container .btl-password-container .submit-button{
			background-color: <?php echo esc_attr( $button_bg_color ); ?>;
		}
		.password-protection-form-container .btl-password-container .input-container input {
			border-color: <?php echo esc_attr( $button_bg_color ); ?>;
		}
	</style>
</head>
<body>
	<div class="password-protection-form-container btl-layout-<?php esc_html_e( $form_template ); ?>">
		<div class="btl-form-header ql-editor">
			<h4><?php _e( $form_title ); // phpcs:ignore ?></h4>
			<?php
			if ( $show_protected_url ) {
				?>
						<a href="<?php esc_url_raw(site_url()) . _e('/') . esc_attr_e( $data['short_url'] ); // phpcs:ignore ?>" class="btl-protected-url">
						    <?php esc_html_e( site_url() ) . _e('/') . esc_html_e( $data['short_url'] ); // phpcs:ignore ?>
						</a>
					<?php
			}
			?>
		</div>
	<div class="btl-password-container">
		<form id="password-form" method="post">
			<div class="input-container">
				<input type="password" id="password" name="password" placeholder="<?php esc_attr_e( 'Password', 'betterlinks-pro' ); ?>" required autofocus>
				<button type="button" id="btl-pass-show-hide" class="dashicons dashicons-hidden"></button>
			</div>
			<button type="submit" class="submit-button"><?php esc_html_e( $button_text, 'betterlinks-pro' ); ?></button>
		</form>
		<div class="error-message" id="error-message" style="display: <?php echo ! empty( $error_message ) ? 'block' : 'none'; ?>">
			<?php esc_html_e( $error_message ); ?>
		</div>
	</div>
	<?php
	if ( ! empty( $is_visitor_allowed_for_contact ) ) {
		?>
				<div class="btl-form-instruction ql-editor">
					<p><?php _e( $allow_contact_text ); // phpcs:ignore ?></p>
				</div>
			<?php
	}
	?>
	</div>


	<script type="text/javascript">
		const passwordField = document.getElementById('password'),
				errorMessage = document.getElementById('error-message'),
				showHideIcon = document.getElementById('btl-pass-show-hide'),
				password = document.getElementById('password');
		
		showHideIcon.addEventListener('click', function(event) {
			event.preventDefault();
			if( showHideIcon.classList.contains('dashicons-hidden') ) {
				password.setAttribute('type', 'text');
				showHideIcon.classList.remove('dashicons-hidden');
				showHideIcon.classList.add('dashicons-visibility');
			}else {
				password.setAttribute('type', 'password');
				showHideIcon.classList.remove('dashicons-visibility');
				showHideIcon.classList.add('dashicons-hidden');
			}
		});
		passwordField.addEventListener('keyup', function(e) {
			if( e.target.value.length == 1 ) {
				errorMessage.style.display = 'none';
			}
		});
	</script>
</body>
</html>
