<?php
namespace BetterLinksPro\Traits;

trait DBTables {
	public function createBetterClicksRotationsTable() {
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		$table_name = $this->wpdb->prefix . 'betterlinks_clicks_rotations';
		$sql        = "CREATE TABLE IF NOT EXISTS $table_name (
            ID bigint(20) unsigned NOT NULL auto_increment,
            link_id bigint(20) NOT NULL,
            click_id bigint(20) NOT NULL,
            target_url varchar(255) NULL,
            PRIMARY KEY  (ID),
            key link_id (link_id),
            key click_id (click_id)
        ) $this->charset_collate;";
		dbDelta( $sql );
	}

	public function modifyBetterLinksClicksTable() {
		global $wpdb;

		// todo: 👇 if `device` column exists that means we already have added device, brand_name, model, bot_name, browser_type, os_version, browser_version, language column
		// todo: so, we need to skip the betterlinks_clicks table alterations
		$check_column_exists_sql = sprintf( 'select `column_name` from information_schema.columns where table_schema="%1$s" and table_name="%2$sbetterlinks_clicks" and column_name="device";', DB_NAME, $wpdb->prefix );
		$result                  = $wpdb->query( $check_column_exists_sql );

		if ( ! $result ) {
			$table_name = $wpdb->prefix . 'betterlinks_clicks';
			$sql        = "ALTER TABLE {$table_name}
                MODIFY created_at datetime NOT NULL default CURRENT_TIMESTAMP,
                MODIFY created_at_gmt datetime NOT NULL default CURRENT_TIMESTAMP,
                ADD COLUMN `device` VARCHAR(20) NULL AFTER `os`,
                ADD COLUMN `brand_name` VARCHAR(20) NULL AFTER `device`,
                ADD COLUMN `model` VARCHAR(20) NULL AFTER `brand_name`,
                ADD COLUMN `bot_name` VARCHAR(20) NULL AFTER `model`,
                ADD COLUMN `browser_type` VARCHAR(20) NULL AFTER `bot_name`,
                ADD COLUMN `os_version` VARCHAR(20) NULL AFTER `browser_type`,
                ADD COLUMN `browser_version` VARCHAR(20) NULL AFTER `os_version`,
                ADD COLUMN `language` VARCHAR(10) NULL AFTER `browser_version`;";

			$wpdb->query( $sql );
		}
	}

	public function createBetterLinkCustomizeMetaTagsTable() {
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		global $wpdb;
		$prefix          = $wpdb->prefix;
		$charset_collate = $wpdb->get_charset_collate();

		$table_name     = $prefix . 'betterlinks_meta_tags';
		$ref_table_name = $prefix . 'betterlinks';
		$sql            = "CREATE TABLE IF NOT EXISTS $table_name (
            `id` INT NOT NULL AUTO_INCREMENT,
            `link_id` bigint(20) unsigned NOT NULL,
            `meta_title` VARCHAR(100),
            `meta_desc` VARCHAR(300),
            `meta_image` TEXT default '',
            `status` boolean default false,
            PRIMARY KEY (`id`),
            FOREIGN KEY (`link_id`) REFERENCES $ref_table_name (`ID`)
                ON DELETE CASCADE
        ) $charset_collate;";
		dbDelta( $sql );
	}
}
