<?php

if ($argc < 2) {
    echo "Usage: php bump-version.php [new-version]\n";
    exit(1);
}

$newVersion = $argv[1];
$pluginFile = 'bitwpfi.php';
$readmeFile = 'readme.txt';

if (!file_exists($pluginFile) || !file_exists($readmeFile)) {
    echo "Required files not found.\n";
    exit(1);
}

$pluginContent = file_get_contents($pluginFile);
$readmeContent = file_get_contents($readmeFile);

$pluginContent = preg_replace_callback(
    '/^(\s*\*\s*Version:\s*)([\d\.]+)/m',
    function ($matches) use ($newVersion) {
        return $matches[1] . $newVersion;
    },
    $pluginContent
);

$pluginContent = preg_replace_callback(
    "/(define\s*\(\s*'BTCBI_PRO_VERSION'\s*,\s*')[\d\.]+('\s*\);)/",
    function ($matches) use ($newVersion) {
        return $matches[1] . $newVersion . $matches[2];
    },
    $pluginContent
);

$readmeContent = preg_replace_callback(
    '/^(Stable tag:\s*)([\d\.]+)/m',
    function ($matches) use ($newVersion) {
        return $matches[1] . $newVersion;
    },
    $readmeContent
);

file_put_contents($pluginFile, $pluginContent);
file_put_contents($readmeFile, $readmeContent);

echo "Updated Version v{$newVersion}\n";
