<?php

namespace BitApps\BTCBI_PRO\Actions\ACPT;

use BitCode\FI\Core\Util\HttpHelper;

class ACPTProHelper
{
    public static function update($default, $apiUrl, $apiKey, $data)
    {
        return HttpHelper::request($apiUrl, 'PUT', $data, self::setHeaders($apiKey));
    }

    public static function delete($default, $apiUrl, $apiKey)
    {
        return HttpHelper::request($apiUrl, 'DELETE', [], self::setHeaders($apiKey));
    }

    public static function createTaxonomyOrOptionPage($default, $apiUrl, $apiKey, $data)
    {
        return HttpHelper::post($apiUrl, $data, self::setHeaders($apiKey));
    }

    public static function associateTaxonomyToCPT($default, $apiUrl, $apiKey)
    {
        return HttpHelper::post($apiUrl, [], self::setHeaders($apiKey));
    }

    private static function setHeaders($apiKey)
    {
        return [
            'acpt-api-key' => $apiKey,
            'Content-Type' => 'application/json',
            'accept'       => 'application/json',
        ];
    }
}
