<?php

/**
 * MailerLite    Record Api
 */

namespace BitApps\BTCBI_PRO\Actions\MailerLite;

use BitCode\FI\Core\Util\HttpHelper;

/**
 * Provide functionality for Record insert, upsert
 */
class MailerLiteHelperPro
{
    public static function deleteSubscriber($default, $subscriberId, $finalData, $baseUrl, $headers, $forget = false)
    {
        $apiEndpoint = $forget
            ? $baseUrl . 'subscribers/' . $subscriberId . '/forget'
            : $baseUrl . 'subscribers/' . $subscriberId;

        $response = HttpHelper::request($apiEndpoint, $forget ? 'POST' : 'DELETE', $finalData, $headers);

        return !$forget && empty($response) ? true : $response;
    }
}
