<?php

namespace BitApps\BTCBI_PRO\Actions\Salesforce;

use BitCode\FI\Actions\Salesforce\SalesforceController;
use BitCode\FI\Core\Util\HttpHelper;

class SalesforceProHelper
{
    public static function getLeadUtilities($default, $params, $key)
    {
        if (
            empty($params->tokenDetails)
            || empty($params->actionName)
            || empty($params->clientId)
            || empty($params->clientSecret)
        ) {
            return ['response' => __('Requested parameter is empty', 'bit-integrations-pro'), 'code' => 400];
        }

        $response = SalesforceController::refreshTokenDetails($params);
        $action = SalesforceController::$actions[$params->actionName] ?? $params->actionName;
        $tokenDetails = $response['tokenDetails'];

        $apiEndpoint = "{$tokenDetails->instance_url}/services/data/v37.0/sobjects/{$action}/describe";

        $apiResponse = HttpHelper::get($apiEndpoint, null, SalesforceController::setHeaders($tokenDetails->access_token));

        if (!property_exists((object) $apiResponse, 'fields')) {
            return ['response' => $apiResponse, 'code' => 400];
        }

        $field = current(array_filter($apiResponse->fields, function ($field) use ($key) {
            return $field->name === $key;
        }));

        if (!empty($tokenDetails)) {
            SalesforceController::saveRefreshedToken($params->flowID, $tokenDetails, $response['organizations']);
        }

        return ['response' => $field->picklistValues ?? [], 'code' => 200];
    }

    public static function addLeadUtilities($data, $actions)
    {
        if (!empty($actions->selectedLeadSource)) {
            $data['LeadSource'] = $actions->selectedLeadSource;
        }
        if (!empty($actions->selectedLeadStatus)) {
            $data['Status'] = $actions->selectedLeadStatus;
        }
        if (!empty($actions->selectedLeadRating)) {
            $data['Rating'] = $actions->selectedLeadRating;
        }
        if (!empty($actions->selectedLeadIndustry)) {
            $data['Industry'] = $actions->selectedLeadIndustry;
        }

        return $data;
    }
}
