<?php

namespace BitApps\BTCBI_PRO\Actions\WishlistMember;

use BitCode\FI\Log\LogHandler;

final class WishlistMemberHelperPro
{
    public static function updateLevel($defaultResponse, $finalData)
    {
        if (!\function_exists('wlmapi_update_level')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        return wlmapi_update_level(
            $finalData['id'],
            $finalData
        );
    }

    public static function deleteLevel($defaultResponse, $finalData)
    {
        if (!\function_exists('wlmapi_delete_level')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        return wlmapi_delete_level($finalData['id']);
    }

    public static function createMember($defaultResponse, $finalData, $levelId = null, $integrationID = null)
    {
        if (!\function_exists('wlmapi_add_member')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        $memberResponse = wlmapi_add_member(
            array_merge(
                $finalData,
                [
                    'ObeyRegistrationRequirements' => false,
                    'SendMail'                     => true,
                    'SendMailPerLevel'             => true,
                ]
            )
        );

        $memberID = $memberResponse['member'][0]['ID'] ?? null;

        if (!$memberID || !$levelId || !\function_exists('wlmapi_add_member_to_level')) {
            return $memberResponse;
        }

        $response = wlmapi_add_member_to_level(
            $levelId,
            [
                'Users'                        => [$memberID],
                'ObeyLevelsAdditionalSettings' => false,
                'SendMail'                     => true,
                'SendMailPerLevel'             => true,
            ]
        );

        $responseType = $response['success'] ? 'success' : 'error';

        LogHandler::save(
            $integrationID,
            [
                'type'      => 'Member',
                'type_name' => 'Add member to level'
            ],
            $responseType,
            wp_json_encode($response)
        );

        return $memberResponse;
    }

    public static function updateMember($defaultResponse, $finalData)
    {
        if (!\function_exists('wlmapi_update_member')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        $memberResult = self::getMemberIdByEmail($finalData['user_email']);

        if (empty($memberResult['success'])) {
            return [
                'success' => false,
                'ERROR'   => $memberResult['message']
            ];
        }

        return wlmapi_update_member($memberResult['id'], $finalData);
    }

    public static function deleteMember($defaultResponse, $finalData)
    {
        if (!\function_exists('wlmapi_delete_member')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        $memberResult = self::getMemberIdByEmail($finalData['user_email']);

        if (empty($memberResult['success'])) {
            return [
                'success' => false,
                'ERROR'   => $memberResult['message']
            ];
        }

        return wlmapi_delete_member($memberResult['id']);
    }

    public static function addMemberToLevel($defaultResponse, $finalData, $levelId)
    {
        if (!\function_exists('wlmapi_add_member_to_level')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        $memberResult = self::getMemberIdByEmail($finalData['user_email']);

        if (empty($memberResult['success'])) {
            return [
                'success' => false,
                'ERROR'   => $memberResult['message']
            ];
        }

        return wlmapi_add_member_to_level(
            $levelId,
            [
                'Users'                        => [$memberResult['id']],
                'ObeyLevelsAdditionalSettings' => false,
                'SendMail'                     => true,
                'SendMailPerLevel'             => true,
            ]
        );
    }

    public static function removeMemberFromLevel($defaultResponse, $finalData, $levelId)
    {
        if (!\function_exists('wlmapi_remove_member_from_level')) {
            return [
                'success' => false,
                'ERROR'   => __('WishlistMember API function not available.', 'bit-pi')
            ];
        }

        $memberResult = self::getMemberIdByEmail($finalData['user_email']);

        if (empty($memberResult['success'])) {
            return [
                'success' => false,
                'ERROR'   => $memberResult['message']
            ];
        }

        return wlmapi_remove_member_from_level($levelId, $memberResult['id']);
    }

    private static function getMemberIdByEmail($email)
    {
        if (!\function_exists('wlmapi_get_member_by')) {
            return ['success' => false, 'message' => __('WishlistMember API function not available.', 'bit-pi')];
        }

        $member = wlmapi_get_member_by('email', $email);
        $memberID = $member['member']['member'][0]['ID'] ?? null;

        if (!$memberID) {
            return ['success' => false, 'message' => __('Member not found.', 'bit-pi')];
        }

        return ['success' => true, 'id' => $memberID];
    }
}
