<?php

namespace BitApps\BTCBI_PRO\Triggers\BookingCalendarContactForm;

use BitCode\FI\Core\Util\Helper;
use BitCode\FI\Flow\Flow;

final class BookingCalendarContactFormController
{
    public static function info()
    {
        return [
            'name'              => 'Booking Calendar Contact Form',
            'type'              => 'custom_form_submission',
            'is_active'         => static::isPluginInstalled(),
            'documentation_url' => 'https://bit-integrations.com/wp-docs/trigger/booking-calendar-contact-form/',
            'tutorial_url'      => '#',
            'tasks'             => [
                'action' => 'booking-calendar-contact-form/get',
                'method' => 'get',
            ],
            'fetch' => [
                'action' => 'trigger/test',
                'method' => 'post',
            ],
            'fetch_remove' => [
                'action' => 'trigger/test/remove',
                'method' => 'post',
            ],
            'isPro' => true
        ];
    }

    public function getAllTasks()
    {
        if (!static::isPluginInstalled()) {
            wp_send_json_error(\sprintf(__('%s is not installed or activated', 'bit-integrations-pro'), 'Booking Calendar Contact Form'));
        }

        wp_send_json_success([
            [
                'form_name'           => __('Form Submission', 'bit-integrations-pro'),
                'triggered_entity_id' => 'dexbccf_process_data',
                'skipPrimaryKey'      => false
            ]
        ]);
    }

    public static function handleFormSubmitted($params)
    {
        if (empty($params['formid'])) {
            return;
        }

        $formData = Helper::prepareFetchFormatFields($params);

        if (empty($formData) || !\is_array($formData)) {
            return;
        }

        Helper::setTestData('btcbi_dexbccf_process_data_test', array_values($formData), 'formid.value', $params['formid']);

        $flows = Flow::exists('BookingCalendarContactForm', 'dexbccf_process_data');

        if (!$flows) {
            return;
        }

        foreach ($flows as $flow) {
            $flowDetails = Helper::parseFlowDetails($flow->flow_details);

            if (
                !isset($flowDetails->primaryKey)
                || !Helper::isPrimaryKeysMatch($formData, $flowDetails->primaryKey)
            ) {
                continue;
            }

            $data = array_column($formData, 'value', 'name');

            Flow::execute('BookingCalendarContactForm', 'dexbccf_process_data', $data, [$flow]);
        }

        return ['type' => 'success'];
    }

    private static function isPluginInstalled()
    {
        return \function_exists('dex_bccf_check_posted_data');
    }
}
