<?php

namespace BitApps\BTCBI_PRO\Triggers\ContactFormEmail;

use BitCode\FI\Core\Util\Helper;
use BitCode\FI\Flow\Flow;

final class ContactFormEmailController
{
    public static function info()
    {
        return [
            'name'              => 'Contact Form Email',
            'type'              => 'custom_form_submission',
            'is_active'         => static::isPluginInstalled(),
            'documentation_url' => 'https://bit-integrations.com/wp-docs/trigger/contact-form-email/',
            'tutorial_url'      => '#',
            'tasks'             => [
                'action' => 'contact-form-email/get',
                'method' => 'get',
            ],
            'fetch' => [
                'action' => 'trigger/test',
                'method' => 'post',
            ],
            'fetch_remove' => [
                'action' => 'trigger/test/remove',
                'method' => 'post',
            ],
            'isPro' => true
        ];
    }

    public function getAllTasks()
    {
        if (!static::isPluginInstalled()) {
            wp_send_json_error(\sprintf(__('%s is not installed or activated', 'bit-integrations-pro'), 'Contact Form Email'));
        }

        wp_send_json_success([
            [
                'form_name'           => __('Form Submission', 'bit-integrations-pro'),
                'triggered_entity_id' => 'cfte_process_data',
                'skipPrimaryKey'      => false
            ]
        ]);
    }

    public static function handleFormSubmitted($params)
    {
        if (isset($_POST['cp_contactformtoemail_id'])) {
            $formId = sanitize_text_field(wp_unslash($_POST['cp_contactformtoemail_id']));
        }

        if (empty($formId)) {
            return;
        }

        $params['form_id'] = $formId;

        $formData = Helper::prepareFetchFormatFields($params);

        if (empty($formData) || !\is_array($formData)) {
            return;
        }

        Helper::setTestData('btcbi_cfte_process_data_test', array_values($formData), 'form_id.value', $formId);

        $flows = Flow::exists('ContactFormEmail', 'cfte_process_data');

        if (!$flows) {
            return;
        }

        foreach ($flows as $flow) {
            $flowDetails = Helper::parseFlowDetails($flow->flow_details);

            if (
                !isset($flowDetails->primaryKey)
                || !Helper::isPrimaryKeysMatch($formData, $flowDetails->primaryKey)
            ) {
                continue;
            }

            $data = array_column($formData, 'value', 'name');

            Flow::execute('ContactFormEmail', 'cfte_process_data', $data, [$flow]);
        }

        return ['type' => 'success'];
    }

    private static function isPluginInstalled()
    {
        return class_exists('CP_CFTEMAIL_BaseClass');
    }
}
