<?php

namespace BitApps\BTCBI_PRO\Triggers\EasyCommerce;

use BitCode\FI\Core\Util\Helper;
use EasyCommerce\Models\Attribute;
use EasyCommerce\Models\Cart;
use EasyCommerce\Models\Coupon;
use EasyCommerce\Models\Customer;
use EasyCommerce\Models\Order;
use EasyCommerce\Models\Product;
use EasyCommerce\Models\Shipping_Plan;

class EasyCommerceHelper
{
    public static function FormatAttributeData($id)
    {
        if (empty($id) || !class_exists('\EasyCommerce\Models\Attribute')) {
            return;
        }

        $attribute = new Attribute();

        $data = (array) $attribute->get($id);

        return Helper::prepareFetchFormatFields($data);
    }

    public static function FormatCouponData($id, $status = false)
    {
        if (empty($id) || !class_exists('\EasyCommerce\Models\Coupon')) {
            return;
        }

        $coupon = new Coupon($id);

        $couponData = self::getCouponData($coupon);

        if ($status) {
            $couponData['status'] = $status;
        }

        return Helper::prepareFetchFormatFields($couponData);
    }

    public static function FormatProductData($id, $status = false, $quantity = false)
    {
        if (empty($id) || !class_exists('\EasyCommerce\Models\Product')) {
            return;
        }

        $product = self::getProductData($id);

        if ($status) {
            $product['status'] = $status;
        }

        if ($quantity) {
            $product['quantity'] = $quantity;
        }

        return Helper::prepareFetchFormatFields($product);
    }

    public static function FormatShippingMethodData($id)
    {
        if (empty($id) || !class_exists('\EasyCommerce\Models\Shipping_Plan')) {
            return;
        }

        $method = (array) Shipping_Plan::get_method_by_id($id);

        return Helper::prepareFetchFormatFields($method);
    }

    public static function FormatOrderData($orderId, $params = [], $newStatus = false, $oldStatus = false)
    {
        if (
            empty($orderId)
            || !class_exists('\EasyCommerce\Models\Order')
        ) {
            return;
        }

        if ($newStatus) {
            $params['new_status'] = $newStatus;
        }

        if ($oldStatus) {
            $params['old_status'] = $oldStatus;
        }

        $params['order'] = self::getOrderData(new Order($orderId));

        if (
            !empty($params['shipping_method'])
            && class_exists('\EasyCommerce\Models\Shipping_Plan')
        ) {
            $method = (array) Shipping_Plan::get_method_by_id($params['shipping_method']);

            $params['shipping_method'] = $method;
        }

        return Helper::prepareFetchFormatFields($params);
    }

    public static function formatAbandonedCartData($hash, $request, $deletedTrigger = false, $isDeleted = false)
    {
        $data = self::getRequestData($request);

        $data['hash'] = $hash;

        if ($deletedTrigger) {
            $data['is_deleted'] = (bool) $isDeleted;
        }

        if (class_exists('\EasyCommerce\Models\Cart')) {
            $cart = new Cart($hash);

            $data['cart'] = $cart->get() ?? [];
            $data['customer'] = $cart->get_customer() ?? [];
        }

        return Helper::prepareFetchFormatFields($data);
    }

    public static function getRequestData($request)
    {
        return [
            'all'     => $request->get_params() ?? [],
            'query'   => $request->get_query_params() ?? [],
            'body'    => $request->get_body_params() ?? [],
            'json'    => $request->get_json_params() ?? [],
            'files'   => $request->get_file_params() ?? [],
            'route'   => $request->get_url_params() ?? [],
            'headers' => $request->get_headers() ?? [],
        ];
    }

    public static function getCouponData($coupon)
    {
        return [
            'id'            => $coupon->get_id(),
            'name'          => $coupon->get_name(),
            'code'          => $coupon->get_code(),
            'discount_type' => $coupon->get_discount_type(),
            'amount'        => $coupon->get_amount(),
            'active'        => $coupon->is_active(),
            'rules'         => $coupon->get_rules(true),
        ];
    }

    public static function isPluginInstalled()
    {
        return \defined('EASYCOMMERCE_VERSION');
    }

    public static function getOrderData($order)
    {
        $data = [
            'id'                 => $order->get_id() ?? null,
            'customer_id'        => $order->get_customer_id() ?? null,
            'total'              => $order->get_total() ?? null,
            'subtotal'           => $order->get_subtotal() ?? null,
            'tax_total'          => $order->get_tax_total() ?? null,
            'shipping_total'     => $order->get_shipping_total() ?? null,
            'discount_total'     => $order->get_discount_total() ?? null,
            'status'             => $order->get_status() ?? null,
            'fulfillment_status' => $order->get_fulfillment_status() ?? null,
            'payment_method'     => $order->get_payment_method() ?? null,
            'transactions'       => $order->get_transactions(true) ?? null,
            'items'              => $order->get_items(true) ?? null,
            'created_at'         => $order->get_created_at() ?? null,
            'updated_at'         => $order->get_updated_at() ?? null,
        ];

        $data['customer'] = self::getCustomerData($data['customer_id']);

        return $data;
    }

    private static function getCustomerData($customerId)
    {
        if (!class_exists('\EasyCommerce\Models\Customer') || empty($customerId)) {
            return [];
        }

        $customer = new Customer($customerId);

        return [
            'id'         => $customer->get_id(),
            'photo'      => $customer->get_photo(),
            'first_name' => $customer->get_first_name(),
            'last_name'  => $customer->get_last_name(),
            'name'       => $customer->get_first_name() . ' ' . $customer->get_last_name(),
            'email'      => $customer->get_email(),
            'since'      => $customer->get_join_date(),
            'aov'        => $customer->get_aov(),
            'ltv'        => $customer->get_ltv(),
            'count'      => $customer->get_order_count(),
            'billing'    => $customer->get_billing_address(),
            'shipping'   => $customer->get_shipping_address(),
            'last_order' => $customer->get_last_order_date(),
        ];
    }

    private static function getProductData($id)
    {
        $product = new Product($id);

        return [
            'id'                 => $product->get_id() ?? null,
            'title'              => $product->get_title() ?? null,
            'slug'               => $product->get_slug() ?? null,
            'description'        => $product->get_description() ?? null,
            'summary'            => $product->get_summary() ?? null,
            'status'             => $product->get_status() ?? null,
            'thumbnail'          => $product->get_thumbnail() ?? null,
            'url'                => $product->get_url() ?? null,
            'gallery'            => $product->get_gallery() ?? null,
            'attributes'         => $product->get_attributes() ?? null,
            'rating'             => $product->get_rating() ?? null,
            'sales'              => $product->get_sales() ?? null,
            'prices'             => $product->get_prices() ?? null,
            'prices_is_variable' => $product->is_variable() ?? null,
            'price'              => $product->get_price() ?? null,
            'sale_price'         => $product->get_sale_price() ?? null,
            'stock'              => $product->get_stock() ?? null,
            'has_variations'     => $product->has_variations() ?? null,
            'variations'         => $product->get_variations() ?? null,
            'downloads'          => $product->get_downloads() ?? null,
            'categories'         => $product->get_categories() ?? null,
            'brands'             => $product->get_brands() ?? null,
            'terms'              => $product->get_terms() ?? null,
            'meta_data'          => $product->get_meta() ?? null,
            'created_at'         => $product->get_created_at() ?? null,
            'updated_at'         => $product->get_updated_at() ?? null,
        ];
    }
}
