<?php

namespace BitApps\BTCBI_PRO\Triggers\EasyCommerce;

class StaticData
{
    public static function forms()
    {
        return [
            // User Events
            [
                'form_name'           => __('User Created', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_user_created',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('User Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_user_updated',
                'skipPrimaryKey'      => true,
            ],

            // Attribute Events
            [
                'form_name'           => __('Attribute Created', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_attribute_added',
                'skipPrimaryKey'      => true,
            ],

            // Cart Events
            [
                'form_name'           => __('Add to Cart', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_add_to_cart',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Cart Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_update_cart',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Product Remove From Cart', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_remove_from_cart',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Cart Cleared', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_clear_cart',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Shipping Method In The Checkout Page', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_shipping_method',
                'skipPrimaryKey'      => true,
            ],

            // Coupon Events
            [
                'form_name'           => __('Coupon Applied', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_apply_coupon',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Coupon Removed From Checkout Page', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_remove_coupon',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Coupon Status Updated (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_coupon_status_updated',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Deleted Coupon (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_before_delete_coupon',
                'skipPrimaryKey'      => true,
            ],

            // Order Events
            [
                'form_name'           => __('Order Created', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_after_create_order',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Status Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_order_status_updated',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Refunded', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_after_refund_order',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Email To The Customer', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_email',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To Processing', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_processing',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To Completed', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_completed',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To Pending', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_pending',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To Refunded', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_refunded',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To On Hold', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_on_hold',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Order Status To Cancelled', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_set_order_status_to_cancelled',
                'skipPrimaryKey'      => true,
            ],

            // Product Events
            [
                'form_name'           => __('Product Created', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_create_product',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Product Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_update_product',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Product Deleted', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_before_delete_product',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Product Status Updated (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_product_status_updated_bulk',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Product Status To Live (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_product_status_updated_to_live_bulk',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Product Status To Draft (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_product_status_updated_to_draft_bulk',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Set Product Status To Trash (Bulk)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_product_status_updated_to_trash_bulk',
                'skipPrimaryKey'      => true,
            ],

            // Abandoned Cart Events
            [
                'form_name'           => __('Abandoned Cart Deleted', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_after_remove_abandoned',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Abandoned Cart Reminder Sent', 'bit-integrations-pro'),
                'triggered_entity_id' => 'easycommerce_before_send_abandoned_reminder',
                'skipPrimaryKey'      => true,
            ],
        ];
    }
}
