<?php

namespace BitApps\BTCBI_PRO\Triggers\FluentAffiliate;

use BitCode\FI\Core\Util\Helper;
use BitCode\FI\Flow\Flow;

final class FluentAffiliateController
{
    public static function info()
    {
        return [
            'name'              => 'FluentAffiliate',
            'type'              => 'custom_form_submission',
            'is_active'         => FluentAffiliateHelper::isPluginInstalled(),
            'documentation_url' => 'https://bit-integrations.com/wp-docs/trigger/fluentaffiliate-integrations/',
            'tutorial_url'      => '#',
            'tasks'             => [
                'action' => 'fluent_affiliate/get',
                'method' => 'get',
            ],
            'fetch' => [
                'action' => 'trigger/test',
                'method' => 'post',
            ],
            'fetch_remove' => [
                'action' => 'trigger/test/remove',
                'method' => 'post',
            ],
            'isPro' => true
        ];
    }

    public function getAllTasks()
    {
        if (!FluentAffiliateHelper::isPluginInstalled()) {
            wp_send_json_error(\sprintf(__('%s is not installed or activated', 'bit-integrations-pro'), 'FluentAffiliate'));
        }

        wp_send_json_success(StaticData::forms());
    }

    public static function handleAffiliateCreated($affiliate)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($affiliate);

        return self::flowExecute('fluent_affiliate/affiliate_created', $formData);
    }

    public static function handleAffiliateUpdated($affiliate, $updatedBy, $updatedData)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateUpdatedData($affiliate, $updatedBy, $updatedData);

        return self::flowExecute('fluent_affiliate/affiliate_updated', $formData);
    }

    public static function handleAffiliateApproved($affiliate)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($affiliate);

        return self::flowExecute('fluent_affiliate/affiliate_status_to_active', $formData);
    }

    public static function handleAffiliatePending($affiliate, $oldStatus)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($affiliate, $oldStatus);

        return self::flowExecute('fluent_affiliate/affiliate_status_to_pending', $formData);
    }

    public static function handleAffiliateInactive($affiliate, $oldStatus)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($affiliate, $oldStatus);

        return self::flowExecute('fluent_affiliate/affiliate_status_to_inactive', $formData);
    }

    public static function handleAffiliateDeleted($affiliate)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($affiliate);

        return self::flowExecute('fluent_affiliate/before_delete_affiliate', $formData);
    }

    public static function handleReferralCreated($referral)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($referral);

        return self::flowExecute('fluent_affiliate/referral_created', $formData);
    }

    public static function handleReferralDeleted($referral)
    {
        $formData = FluentAffiliateHelper::FormatAffiliateData($referral);

        return self::flowExecute('fluent_affiliate/referral/before_delete', $formData);
    }

    private static function flowExecute($entityId, $formData)
    {
        if (empty($formData) || !\is_array($formData)) {
            return;
        }

        Helper::setTestData("btcbi_{$entityId}_test", array_values($formData));

        $flows = Flow::exists('FluentAffiliate', $entityId);

        if (!$flows) {
            return;
        }

        $data = array_column($formData, 'value', 'name');

        Flow::execute('FluentAffiliate', $entityId, $data, $flows);

        return ['type' => 'success'];
    }
}
