<?php

namespace BitApps\BTCBI_PRO\Triggers\FluentAffiliate;

use BitCode\FI\Core\Util\Helper;

class FluentAffiliateHelper
{
    public static function FormatAffiliateData($affiliate, $oldStatus = null)
    {
        $affiliate = (array) Helper::jsonEncodeDecode($affiliate);

        if (!empty($oldStatus)) {
            $affiliate['old_status'] = $oldStatus;
        }

        return Helper::prepareFetchFormatFields($affiliate);
    }

    public static function FormatAffiliateUpdatedData($affiliate, $updatedBy, $updatedData)
    {
        $affiliate = (array) Helper::jsonEncodeDecode($affiliate);

        $mergedData = array_merge(
            ['updated_by' => $updatedBy],
            $affiliate,
            $updatedData
        );

        return Helper::prepareFetchFormatFields($mergedData);
    }

    public static function isPluginInstalled()
    {
        return \defined('FLUENT_AFFILIATE_VERSION');
    }
}
