<?php

if (!defined('ABSPATH')) {
    exit;
}

use BitApps\BTCBI_PRO\Core\Util\Hooks;
use BitApps\BTCBI_PRO\Triggers\FluentCart\FluentCartController;

Hooks::add('fluent_cart/checkout/prepare_other_data', [FluentCartController::class, 'productPurchased']);
Hooks::add('fluent_cart/checkout/cart_amount_updated', [FluentCartController::class, 'cartUpdated']);
Hooks::add('fluent_cart/product_updated', [FluentCartController::class, 'productUpdated']);
Hooks::add('fluent_cart/order_refunded', [FluentCartController::class, 'orderRefunded']);
Hooks::add('fluent_cart/order_partially_refunded', [FluentCartController::class, 'orderPartiallyRefunded']);
Hooks::add('fluent_cart/order_fully_refunded', [FluentCartController::class, 'orderFullyRefunded']);
Hooks::add('fluent_cart/order_status_changed', [FluentCartController::class, 'orderStatusChanged']);
Hooks::add('fluent_cart/order_status_changed_to_canceled', [FluentCartController::class, 'orderCancelled']);
Hooks::add('fluent_cart/order_status_changed_to_processing', [FluentCartController::class, 'orderStatusUpdatedToProcessing']);
Hooks::add('fluent_cart/order_status_changed_to_completed', [FluentCartController::class, 'orderStatusUpdatedToCompleted']);
Hooks::add('fluent_cart/order_status_changed_to_on-hold', [FluentCartController::class, 'orderStatusUpdatedToOnHold']);
Hooks::add('fluent_cart/shipping_status_changed', [FluentCartController::class, 'orderShippingStatusChanged']);
Hooks::add('fluent_cart/shipping_status_changed_to_shipped', [FluentCartController::class, 'orderShipped']);
Hooks::add('fluent_cart/shipping_status_changed_to_unshipped', [FluentCartController::class, 'orderUnshipped']);
Hooks::add('fluent_cart/shipping_status_changed_to_unshippable', [FluentCartController::class, 'orderUnshippable']);
Hooks::add('fluent_cart/shipping_status_changed_to_delivered', [FluentCartController::class, 'orderDelivered']);
Hooks::add('fluent_cart/order_paid_done', [FluentCartController::class, 'orderMarkedAsPaid']);
