<?php

namespace BitApps\BTCBI_PRO\Triggers\FluentCart;

class StaticData
{
    public static function tasks()
    {
        return [
            [
                'form_name'           => __('Product Purchased', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/checkout/prepare_other_data',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Product Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/product_updated',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Cart Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/checkout/cart_amount_updated',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Refunded (Full or Partial)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_refunded',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Refunded (Partial)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_partially_refunded',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Refunded (Full)', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_fully_refunded',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Cancelled', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_status_changed_to_canceled',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Status Changed', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_status_changed',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Status Updated To Processing', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_status_changed_to_processing',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Status Updated To Completed', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_status_changed_to_completed',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Status Updated To On-Hold', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_status_changed_to_on-hold',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Shipping Status Changed', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/shipping_status_changed',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Shipped', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/shipping_status_changed_to_shipped',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Unshipped', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/shipping_status_changed_to_unshipped',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Unshippable', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/shipping_status_changed_to_unshippable',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Delivered', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/shipping_status_changed_to_delivered',
                'skipPrimaryKey'      => true,
            ],
            [
                'form_name'           => __('Order Marked As Paid', 'bit-integrations-pro'),
                'triggered_entity_id' => 'fluent_cart/order_paid_done',
                'skipPrimaryKey'      => true,
            ],
        ];
    }
}
