<?php

namespace BitApps\BTCBI_PRO\Triggers\GeoDirectory;

use BitCode\FI\Core\Util\Helper;
use BitCode\FI\Flow\Flow;

final class GeoDirectoryController
{
    public static function info()
    {
        return [
            'name'              => 'GeoDirectory',
            'title'             => __('GeoDirectory', 'bit-integrations-pro'),
            'type'              => 'custom_form_submission',
            'is_active'         => GeoDirectoryHelper::isPluginInstalled(),
            'documentation_url' => 'https://bit-integrations.com/wp-docs/trigger/geodirectory-integrations/',
            'tutorial_url'      => '#',
            'tasks'             => [
                'action' => 'geo_directory/get',
                'method' => 'get',
            ],
            'fetch' => [
                'action' => 'trigger/test',
                'method' => 'post',
            ],
            'fetch_remove' => [
                'action' => 'trigger/test/remove',
                'method' => 'post',
            ],
            'isPro' => true
        ];
    }

    public function getAllTasks()
    {
        if (!GeoDirectoryHelper::isPluginInstalled()) {
            wp_send_json_error(\sprintf(__('%s is not installed or activated', 'bit-integrations-pro'), 'GeoDirectory'));
        }

        wp_send_json_success([
            [
                'form_name'           => __('New Place Listing Added', 'bit-integrations-pro'),
                'triggered_entity_id' => 'geodir_post_published',
                'skipPrimaryKey'      => true
            ],
        ]);
    }

    public static function handleNewPlaceListingAdded($post, $data)
    {
        $formData = GeoDirectoryHelper::formatPostData($post, $data);

        if (empty($formData) || !\is_array($formData)) {
            return;
        }

        Helper::setTestData('btcbi_geodir_post_published_test', array_values($formData));

        $flows = Flow::exists('GeoDirectory', 'geodir_post_published');

        if (!$flows) {
            return;
        }

        $data = array_column($formData, 'value', 'name');

        Flow::execute('GeoDirectory', 'geodir_post_published', $data, $flows);

        return ['type' => 'success'];
    }
}
