<?php

namespace BitApps\BTCBI_PRO\Triggers\GeoDirectory;

use BitCode\FI\Core\Util\User;
use BitCode\FI\Core\Util\Helper;

class GeoDirectoryHelper
{
    public static function formatPostData($post, $data)
    {
        if (empty($post) || empty($post->ID)) {
            return;
        }

        $postType = $post->post_type;
        $postId = $post->ID;

        if (!\function_exists('geodir_is_gd_post_type') || !geodir_is_gd_post_type($postType)) {
            return;
        }

        $finalData = array_merge(
            User::get(absint($post->post_author)),
            (array) $post,
            [
                'categories'  => self::getTermByTaxonomy($postId, $postType . 'category'),
                'tags'        => self::getTermByTaxonomy($postId, $postType . '_tags'),
                'attachments' => self::getAttachments($postId),
            ],
            $data
        );

        return Helper::prepareFetchFormatFields($finalData);
    }

    public static function isPluginInstalled()
    {
        return class_exists('GeoDirectory');
    }

    private static function getTermByTaxonomy($postId, $taxonomy)
    {
        $terms = [];

        if (!taxonomy_exists($taxonomy)) {
            return $terms;
        }

        $postTerms = wp_get_post_terms($postId, $taxonomy);

        if (is_wp_error($postTerms) || empty($postTerms)) {
            return $terms;
        }

        foreach ($postTerms as $term) {
            $terms[] = $term->name;
        }

        return $terms;
    }

    private static function getAttachments($postId)
    {
        $attachments = [];

        if (!\function_exists('geodir_get_images')) {
            return $attachments;
        }

        $images = geodir_get_images($postId);

        if (empty($images)) {
            return $attachments;
        }

        foreach ($images as $image) {
            if (!empty($image->file)) {
                $attachments[] = $image->file;
            }
        }

        return $attachments;
    }
}
