<?php

namespace BitApps\BTCBI_PRO\Triggers\GiveWp;

use BitCode\FI\Flow\Flow;
use Give_Payment;
use Give_Subscription;

final class GiveWpFallback
{
    /**
     * Handle user donation
     *
     * @deprecated since 2.6.2
     *
     * @param int   $payment_id
     * @param array $flows
     */
    public static function handleUserDonation($payment_id, $flows)
    {
        $payment = new Give_Payment($payment_id);

        if (empty($payment) || empty($payment->ID) || empty($payment->user_id)) {
            return;
        }

        $finalData = json_decode(wp_json_encode($payment), true);

        $donarUserInfo = give_get_payment_meta_user_info($payment_id);
        if ($donarUserInfo) {
            $finalData['title'] = $donarUserInfo['title'];
            $finalData['first_name'] = $donarUserInfo['first_name'];
            $finalData['last_name'] = $donarUserInfo['last_name'];
            $finalData['email'] = $donarUserInfo['email'];
            $finalData['address1'] = $donarUserInfo['address']['line1'];
            $finalData['address2'] = $donarUserInfo['address']['line2'];
            $finalData['city'] = $donarUserInfo['address']['city'];
            $finalData['state'] = $donarUserInfo['address']['state'];
            $finalData['zip'] = $donarUserInfo['address']['zip'];
            $finalData['country'] = $donarUserInfo['address']['country'];
            $finalData['donar_id'] = $donarUserInfo['donor_id'];
        }

        $finalData['give_form_id'] = $payment->form_id;
        $finalData['give_form_title'] = $payment->form_title;
        $finalData['currency'] = $payment->currency;
        $finalData['give_price_id'] = $payment->price_id;
        $finalData['price'] = $payment->total;

        $flowDetails = json_decode($flows[0]->flow_details);
        $selectedDonationForm = !empty($flowDetails->selectedDonationForm) ? $flowDetails->selectedDonationForm : [];

        if ($flows && $payment->form_id === $selectedDonationForm || $selectedDonationForm === 'any') {
            Flow::execute('GiveWp', 1, $finalData, $flows);
        }
    }

    /**
     * Handle subscription donation cancel
     *
     * @deprecated since 2.6.2
     *
     * @param int    $subscriptionId
     * @param object $subscription
     * @param array  $flows
     */
    public static function handleSubscriptionDonationCancel($subscriptionId, $subscription, $flows)
    {
        $donor = $subscription->donor;

        if (empty($donor->user_id)) {
            return;
        }

        $getUserData = GiveWpHelper::getUserInfo($donor->user_id);

        $finalData = [
            'subscription_id' => $subscriptionId,
            'give_form_id'    => $subscription->form_id,
            'amount'          => $subscription->recurring_amount,
            'donor'           => $donor,
            'user_id'         => $donor->user_id,
            'first_name'      => $getUserData['first_name'],
            'last_name'       => $getUserData['last_name'],
            'user_email'      => $getUserData['email'],
            'nickname'        => $getUserData['nickname'],
            'avatar_url'      => $getUserData['avatar_url'],
        ];

        $flowDetails = json_decode($flows[0]->flow_details);
        $selectedRecurringDonationForm = !empty($flowDetails->selectedRecurringDonationForm) ? $flowDetails->selectedRecurringDonationForm : '';

        if ($flows && !empty($selectedRecurringDonationForm) && $subscription->form_id === $selectedRecurringDonationForm) {
            Flow::execute('GiveWp', 2, $finalData, $flows);
        }
    }

    /**
     * Handle recurring donation
     *
     * @deprecated since 2.6.2
     *
     * @param int   $rowId
     * @param array $data
     * @param array $flows
     */
    public static function handleRecurringDonation($rowId, $data, $flows)
    {
        $subscription = new Give_Subscription($rowId);
        $recurring_amount = $subscription->recurring_amount;
        $give_form_id = $subscription->form_id;

        $total_payment = $subscription->get_total_payments();
        $donor = $subscription->donor;
        $user_id = $donor->user_id;

        if (0 === absint($user_id)) {
            return;
        }

        if ($total_payment > 1 && 'active' === (string) $data['status']) {
            $user = GiveWpHelper::getUserInfo($user_id);
            $finalData = [
                'give_form_id'     => $give_form_id,
                'recurring_amount' => $recurring_amount,
                'total_payment'    => $total_payment,
                'donor'            => $donor,
                'user_id'          => $user_id,
                'first_name'       => $user['first_name'],
                'last_name'        => $user['last_name'],
                'user_email'       => $user['user_email'],
                'nickname'         => $user['nickname'],
                'avatar_url'       => $user['avatar_url'],
            ];
        }

        Flow::execute('GiveWp', 3, $finalData, $flows);
    }
}
