<?php

namespace BitApps\BTCBI_PRO\Triggers\WPTravelEngine;

use BitCode\FI\Core\Util\Helper;
use BitCode\FI\Flow\Flow;

final class WPTravelEngineController
{
    public static function info()
    {
        return [
            'name'              => 'WP Travel Engine',
            'type'              => 'custom_form_submission',
            'is_active'         => static::isPluginInstalled(),
            'documentation_url' => '#',
            'tutorial_url'      => '#',
            'tasks'             => [
                'action' => 'wp_travel_engine/get',
                'method' => 'get',
            ],
            'fetch' => [
                'action' => 'trigger/test',
                'method' => 'post',
            ],
            'fetch_remove' => [
                'action' => 'trigger/test/remove',
                'method' => 'post',
            ],
            'isPro' => true
        ];
    }

    public function getAllTasks()
    {
        if (!static::isPluginInstalled()) {
            wp_send_json_error(\sprintf(__('%s is not installed or activated', 'bit-integrations-pro'), 'WP Travel Engine'));
        }

        wp_send_json_success([
            [
                'form_name'           => __('Booking Created', 'bit-integrations-pro'),
                'triggered_entity_id' => 'booking_created',
                'skipPrimaryKey'      => true
            ],
            [
                'form_name'           => __('Booking Updated', 'bit-integrations-pro'),
                'triggered_entity_id' => 'booking_updated',
                'skipPrimaryKey'      => true
            ],
            // [
            //     'form_name'           => __('Enquiry Created', 'bit-integrations-pro'),
            //     'triggered_entity_id' => 'enquiry_created',
            //     'skipPrimaryKey'      => true
            // ],
        ]);
    }

    public static function handleBookingCreated($bookingData, $booking)
    {
        $bookingData['booked_trip'] = reset($bookingData['booked_trips']);

        return static::flowExecute('booking_created', array_merge($bookingData, (array) $booking));
    }

    public static function handleBookingUpdated($bookingData, $booking)
    {
        $bookingData['booked_trip'] = reset($bookingData['booked_trips']);

        return static::flowExecute('booking_updated', array_merge($bookingData, (array) $booking));
    }

    public static function handleEnquiryCreated($enquiry)
    {
        return static::flowExecute(
            'enquiryCreated',
            array_merge(
                $enquiry->get_data() ?? [],
                $enquiry->get_enquiry_data() ?? [],
                $enquiry->post ?? [],
            )
        );
    }

    private static function flowExecute($entityId, $data)
    {
        if (!static::isPluginInstalled()) {
            return;
        }

        $formData = Helper::prepareFetchFormatFields((array) $data);

        if (empty($formData) || !\is_array($formData)) {
            return;
        }

        Helper::setTestData("btcbi_{$entityId}_test", array_values($formData));

        $flows = Flow::exists('WPTravelEngine', $entityId);

        if (!$flows) {
            return;
        }

        Flow::execute('WPTravelEngine', $entityId, array_column($formData, 'value', 'name'), $flows);

        return ['type' => 'success'];
    }

    private static function isPluginInstalled()
    {
        return class_exists('\WPTravelEngine\Plugin');
    }
}
