<?php

namespace BitApps\PiPro\src\Integrations\ActiveCampaign;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Authorization\AuthorizationFactory;
use BitApps\Pi\src\Authorization\AuthorizationType;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

class ActiveCampaignAction implements ActionInterface
{
    private NodeInfoProvider $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeActiveCampaignAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'],
            $executedNodeAction['payload'],
            $executedNodeAction['response']
        );
    }

    private function executeMachine($machineSlug, $data, $apiKey, $authDetails)
    {
        $header = [
            'content-Type' => 'application/json',
            'accept'       => 'application/json',
            'Api-Token'    => $apiKey
        ];
        $url = $authDetails->extraData->url;

        $activeCampaignHelperObj = new ActiveCampaignHelper($header, $url);

        switch ($machineSlug) {
            case 'createContact':
                return $activeCampaignHelperObj->createContact($data);

                break;

            case 'updateContact':
                return $activeCampaignHelperObj->updateContact($data);

                break;

            case 'createAccount':
                $fields = $this->nodeInfoProvider->getFieldMapRepeaters('fields.value', false, false);

                return $activeCampaignHelperObj->createAccount($data, $fields);

                break;

            case 'updateAccount':
                $fields = $this->nodeInfoProvider->getFieldMapRepeaters('fields.value', false, false);

                return $activeCampaignHelperObj->updateAccount($data, $fields);

                break;

            case 'addOrRemoveTagContact':
                return $activeCampaignHelperObj->addOrRemoveTagContact($data);

                break;

            case 'addOrRemoveContactAutomation':
                return $activeCampaignHelperObj->addOrRemoveContactAutomation($data);

                break;

            case 'subscribeOrUnsubscribeContactList':
                return $activeCampaignHelperObj->subscribeOrUnsubscribeContactList($data);

                break;

            case 'createDeal':
                $fields = $this->nodeInfoProvider->getFieldMapRepeaters('fields.value', false, false);

                return $activeCampaignHelperObj->createDeal($data, $fields);

                break;


            case 'findUser':
                return $activeCampaignHelperObj->findUser($data);

                break;

            case 'findAccount':
                return $activeCampaignHelperObj->findAccount($data);

                break;

            case 'findContact':
                return $activeCampaignHelperObj->findContact($data);

                break;

            case 'getAllContact':
                return $activeCampaignHelperObj->getAllContact();

                break;

            case 'getAllAccount':
                return $activeCampaignHelperObj->getAllAccount();

                break;

            case 'getAllUser':
                return $activeCampaignHelperObj->getAllUser();

                break;
        }
    }

    private function executeActiveCampaignAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();
        $connectionId = $this->nodeInfoProvider->getFieldMapConfigs('connection-id.value');
        $data = $this->nodeInfoProvider->getFieldMapData();

        $tokenAuthorization = AuthorizationFactory::getAuthorizationHandler(
            AuthorizationType::API_KEY,
            $connectionId
        );
        $apiKey = $tokenAuthorization->getAccessToken();
        $authDetails = $tokenAuthorization->getAuthDetails();

        return $this->executeMachine($machineSlug, $data, $apiKey, $authDetails);
    }
}
