<?php

namespace BitApps\PiPro\src\Integrations\BookingCalendarContactForm;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class BookingCalendarContactFormTrigger
{
    public static function formSubmission($params)
    {
        if (empty($params['formid'])) {
            return;
        }

        $flows = FlowService::exists('BookingCalendarContactForm', 'formSubmission');

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $params);
    }

    private static function isPluginInstalled()
    {
        return \function_exists('dex_bccf_check_posted_data');
    }
}
