<?php

namespace BitApps\PiPro\src\Integrations\Breakdance;

use Breakdance\Forms\Actions\Action;
use Exception;

if (!\defined('ABSPATH')) {
    exit;
}

class BreakdanceFormAction extends Action
{
    /**
     * Get the name of the action.
     *
     * @return string that will be used to identify this action in the Form Builder Actions dropdown menu
     */
    public static function name()
    {
        return 'Bit Flows';
    }

    /**
     * Get the slug of the action.
     *
     * @return string To identify the form action.
     * This should be unique across all form actions,
     * so it is recommended to prefix the slug appropriately.
     */
    public static function slug()
    {
        return 'bit-pi';
    }

    /**
     * Run the action.
     *
     * @param array $form
     * @param array $settings
     * @param array $extra
     *
     * @return array
     */
    public function run($form, $settings, $extra)
    {
        try {
            BreakdanceTrigger::formSubmission($form, $settings, $extra);
        } catch (Exception $e) {
            return ['type' => 'error', 'message' => $e->getMessage()];
        }

        return ['type' => 'success', 'message' => 'Submission logged to file'];
    }
}
