<?php

namespace BitApps\PiPro\src\Integrations\BricksBuilder;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class BricksBuilderTrigger
{
    public static function bricksFormSubmit($form)
    {
        $flows = FlowService::exists('bricksBuilder', 'bricksFormSubmit');

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm(
            $flows,
            [
                'uploaded_files' => $form->get_uploaded_files(),
                'form_fields'    => $form->get_fields(),
                'form_settings'  => $form->get_settings(),
            ]
        );
    }

    // TODO:: need to implement
    private static function isPluginInstalled()
    {
        return wp_get_theme()->get_template() === 'bricks';
    }
}
