<?php

namespace BitApps\PiPro\src\Integrations\FluentCommunity;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FluentCommunityAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executeFluentCommunityAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeFluentCommunityAction()
    {
        $fluentCommunityService = new FluentCommunityService($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'addUserToSpace':
                return $fluentCommunityService->addUserToSpace();

            case 'removeUserFromSpace':
                return $fluentCommunityService->removeUserFromSpace();

            case 'getUserSpaceList':
                return $fluentCommunityService->getUserSpaceList();

            case 'getAllSpaceList':
                return $fluentCommunityService->getAllSpacesList();

            case 'getSpaceUserList':
                return $fluentCommunityService->getSpaceUsersList();

            case 'addUserToCourse':
                return $fluentCommunityService->addUserToCourse();

            case 'removeUserFromCourse':
                return $fluentCommunityService->removeUserFromCourse();

            case 'addUserToMultipleCourses':
                return $fluentCommunityService->addUserToMultipleCourses();

            case 'removeUserFromMultipleCourses':
                return $fluentCommunityService->removeUserFromMultipleCourses();

            case 'getUserCoursesList':
                return $fluentCommunityService->getUserCoursesList();

            case 'getAllCoursesList':
                return $fluentCommunityService->getAllCoursesList();

            case 'createNewPostInFeed':
                return $fluentCommunityService->createNewPostInFeed();

            case 'createNewPollInFeed':
                return $fluentCommunityService->createNewPollInFeed();


            case 'getUserCommunityProfile':
                return $fluentCommunityService->getUserCommunityProfile();

            case 'verifyUserProfile':
                return $fluentCommunityService->verifyUserProfile();

            case 'changeMemberStatus':
                return $fluentCommunityService->changeMemberStatus();

            default:
                return [
                    'status_code' => 400,
                    'payload'     => [],
                    'response'    => [
                        'status'  => false,
                        'message' => 'Invalid machine slug: ' . $machineSlug,
                    ],
                ];
        }
    }
}
