<?php

namespace BitApps\PiPro\src\Integrations\FluentCommunity;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FluentCommunityHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            // Space Events
            'userJoinsSpace' => [
                'hook'          => 'fluent_community/space/joined',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserJoinsSpace'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],
            'userRequestsSpaceJoin' => [
                'hook'          => 'fluent_community/space/join_requested',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserRequestsSpaceJoin'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'userLeavesSpace' => [
                'hook'          => 'fluent_community/space/user_left',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserLeavesSpace'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],
            'newSpaceCreated' => [
                'hook'          => 'fluent_community/space/created',
                'callback'      => [FluentCommunityTrigger::class, 'handleNewSpaceCreated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'afterSpaceDeleted' => [
                'hook'          => 'fluent_community/space/deleted',
                'callback'      => [FluentCommunityTrigger::class, 'handleAfterSpaceDeleted'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'afterSpaceUpdated' => [
                'hook'          => 'fluent_community/space/updated',
                'callback'      => [FluentCommunityTrigger::class, 'handleAfterSpaceUpdated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],

            // Feed Events
            'newFeedCreated' => [
                'hook'          => 'fluent_community/feed/created',
                'callback'      => [FluentCommunityTrigger::class, 'handleNewFeedCreated'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'newSpaceFeedCreated' => [
                'hook'          => 'fluent_community/space_feed/created',
                'callback'      => [FluentCommunityTrigger::class, 'handleNewSpaceFeedCreated'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'feedUpdated' => [
                'hook'          => 'fluent_community/feed/updated',
                'callback'      => [FluentCommunityTrigger::class, 'handleFeedUpdated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'feedMentionsUser' => [
                'hook'          => 'fluent_community/feed_mentioned',
                'callback'      => [FluentCommunityTrigger::class, 'handleFeedMentionsUser'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'beforeFeedDeleted' => [
                'hook'          => 'fluent_community/feed/before_deleted',
                'callback'      => [FluentCommunityTrigger::class, 'handleBeforeFeedDeleted'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'afterFeedDeleted' => [
                'hook'          => 'fluent_community/feed/deleted',
                'callback'      => [FluentCommunityTrigger::class, 'handleAfterFeedDeleted'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'feedReactionAdded' => [
                'hook'          => 'fluent_community/feed/react_added',
                'callback'      => [FluentCommunityTrigger::class, 'handleFeedReactionAdded'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],

            // Comment Events
            'newCommentAdded' => [
                'hook'          => 'fluent_community/comment_added',
                'callback'      => [FluentCommunityTrigger::class, 'handleNewCommentAdded'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'commentUpdated' => [
                'hook'          => 'fluent_community/comment_updated',
                'callback'      => [FluentCommunityTrigger::class, 'handleCommentUpdated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'commentDeleted' => [
                'hook'          => 'fluent_community/comment_deleted',
                'callback'      => [FluentCommunityTrigger::class, 'handleCommentDeleted'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],

            // Course Events
            'userEnrollsInCourse' => [
                'hook'          => 'fluent_community/course/enrolled',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserEnrollsInCourse'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],
            'userUnenrollsFromCourse' => [
                'hook'          => 'fluent_community/course/student_left',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserUnenrollsFromCourse'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],
            'userCompletesCourse' => [
                'hook'          => 'fluent_community/course/completed',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserCompletesCourse'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'userCompletesLesson' => [
                'hook'          => 'fluent_community/course/lesson_completed',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserCompletesLesson'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'courseCreated' => [
                'hook'          => 'fluent_community/course/created',
                'callback'      => [FluentCommunityTrigger::class, 'handleCourseCreated'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'courseUpdated' => [
                'hook'          => 'fluent_community/course/updated',
                'callback'      => [FluentCommunityTrigger::class, 'handleCourseUpdated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'coursePublished' => [
                'hook'          => 'fluent_community/course/published',
                'callback'      => [FluentCommunityTrigger::class, 'handleCoursePublished'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'courseDeleted' => [
                'hook'          => 'fluent_community/course/deleted',
                'callback'      => [FluentCommunityTrigger::class, 'handleCourseDeleted'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'lessonUpdated' => [
                'hook'          => 'fluent_community/lesson/updated',
                'callback'      => [FluentCommunityTrigger::class, 'handleLessonUpdated'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],

            // User Events
            'userLeveledUp' => [
                'hook'          => 'fluent_community/user_level_upgraded',
                'callback'      => [FluentCommunityTrigger::class, 'handleUserLeveledUp'],
                'priority'      => 20,
                'accepted_args' => 3,
            ],
        ];
    }
}
