<?php

namespace BitApps\PiPro\src\Integrations\FormGent;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class FormGentHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'formSubmitted' => [
                'hook'          => 'formgent_after_create_form_response',
                'callback'      => [FormGentTrigger::class, 'formSubmitted'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
            'formCreated' => [
                'hook'          => 'formgent_after_create_form',
                'callback'      => [FormGentTrigger::class, 'formCreated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'formTitleUpdated' => [
                'hook'          => 'formgent_after_update_form_title',
                'callback'      => [FormGentTrigger::class, 'formTitleUpdated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'formStatusUpdated' => [
                'hook'          => 'formgent_after_update_form_status',
                'callback'      => [FormGentTrigger::class, 'formStatusUpdated'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'formDuplicated' => [
                'hook'          => 'formgent_after_duplicate_form',
                'callback'      => [FormGentTrigger::class, 'formDuplicated'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'formDeleted' => [
                'hook'          => 'formgent_after_delete_form',
                'callback'      => [FormGentTrigger::class, 'formDeleted'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'formResponsesDeleted' => [
                'hook'          => 'formgent_after_delete_responses',
                'callback'      => [FormGentTrigger::class, 'formResponsesDeleted'],
                'priority'      => 10,
                'accepted_args' => 2,
            ],
            'formResponseStarred' => [
                'hook'          => 'formgent_after_update_response_starred',
                'callback'      => [FormGentTrigger::class, 'formResponseStarred'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'formResponseRead' => [
                'hook'          => 'formgent_after_update_response_read',
                'callback'      => [FormGentTrigger::class, 'formResponseRead'],
                'priority'      => 10,
                'accepted_args' => 1,
            ],
            'viewQuizResult' => [
                'hook'          => 'formgent_after_quiz_result',
                'callback'      => [FormGentTrigger::class, 'viewQuizResult'],
                'priority'      => 10,
                'accepted_args' => 2,
            ]
        ];
    }
}
