<?php

namespace BitApps\PiPro\src\Integrations\Klaviyo;

use BitApps\PiPro\Deps\BitApps\WPKit\Helpers\JSON;
use BitApps\PiPro\Deps\BitApps\WPKit\Http\Client\HttpClient;

if (!\defined('ABSPATH')) {
    exit;
}

class KlaviyoService
{
    private $http;

    private $headers;

    private $baseUrl;

    /**
     * KlaviyoService constructor.
     *
     * @param array $headers
     */
    public function __construct($headers)
    {
        $this->http = new HttpClient();
        $this->headers = $headers;
        $this->baseUrl = 'https://a.klaviyo.com/api';
    }

    public function createProfile($fieldMapData, $addToList, $listId)
    {
        $endPoint = $this->baseUrl . '/profiles/';
        $profileData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $profileData, $this->headers);
        $profileId = $response->data->id ?? null;
        $formData[] = [
            'type' => 'profile',
            'id'   => $profileId
        ];

        if ($addToList === true && $profileId) {
            $this->addProfileToList($formData, $listId);
        }

        return [
            'response'    => $response,
            'payload'     => $profileData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    public function createList($fieldMapData)
    {
        $endPoint = $this->baseUrl . '/lists/';
        $listData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $listData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $listData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    public function createEvent($fieldMapData)
    {
        $endPoint = $this->baseUrl . '/events';
        $eventData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'POST', $eventData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $eventData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    public function updateList($fieldMapData, $listId)
    {
        $endPoint = $this->baseUrl . '/lists/' . $listId;
        $updateListData = JSON::encode($fieldMapData);
        $response = $this->http->request($endPoint, 'PATCH', $updateListData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $updateListData,
            'status_code' => $this->http->getResponseCode()
        ];
    }

    public function addProfileToList($profileIds, $listId)
    {
        $endPoint = $this->baseUrl . '/lists/' . $listId . '/relationships/profiles';
        $profileToListData['data'] = $profileIds;
        $profileRequestData = JSON::encode($profileToListData);
        $response = $this->http->request($endPoint, 'POST', $profileRequestData, $this->headers);

        return [
            'response'    => $response,
            'payload'     => $profileRequestData,
            'status_code' => $this->http->getResponseCode()
        ];
    }
}
