<?php

namespace BitApps\PiPro\src\Integrations\MailPoet;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;
use MailPoet\API\API;

if (!\defined('ABSPATH')) {
    exit;
}


class MailPoetAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        if (!class_exists(API::class)) {
            return Utility::formatResponseData(500, [], __('MailPoet is not installed or activated', 'bit-pi'));
        }

        $executedNodeAction = $this->executeMailPoetAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executeMailPoetAction()
    {
        $mailPoetService = new MailPoetServices($this->nodeInfoProvider);

        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        switch ($machineSlug) {
            case 'createList':
                return $mailPoetService->createList();

                break;

            case 'updateList':
                return $mailPoetService->updateList();

                break;

            case 'deleteList':
                return $mailPoetService->deleteList();

                break;

            case 'getAllList':
                return $mailPoetService->getAllList();

                break;

            case 'createSubscriber':
                return $mailPoetService->createSubscriber();

                break;

            case 'updateSubscriber':
                return $mailPoetService->updateSubscriber();

                break;

            case 'getAllSubscriber':
                return $mailPoetService->getSubscribers();

                break;

            case 'getSubscriber':
                return $mailPoetService->getSubscriber();

                break;

            case 'getSubscriberByList':
                return $mailPoetService->getSubscriberByList();

                break;

            case 'getSubscriberByStatus':
                return $mailPoetService->getSubscriberByStatus();

                break;

            case 'getSubscriberCount':
                return $mailPoetService->getSubscriberCount();

                break;

            case 'subscribeToLists':
                return $mailPoetService->subscribeToLists();

                break;

            case 'unsubscribeGlobally':
                return $mailPoetService->unsubscribeGlobally();

                break;

            case 'unsubscribeFromLists':
                return $mailPoetService->unsubscribeFromLists();

                break;
        }
    }
}
