<?php

namespace BitApps\PiPro\src\Integrations\MailPoet;

use BitApps\PiPro\Deps\BitApps\WPKit\Http\Response;
use MailPoet\API\API;

if (!\defined('ABSPATH')) {
    exit;
}


final class MailPoetHelper
{
    public function getLists()
    {
        if (!class_exists(API::class)) {
            // translators: %s: Plugin name
            return Response::error(\sprintf(__('%s is not installed or activated', 'bit-pi'), 'MailPoet'));
        }

        $mailPoetApi = API::MP('v1');

        $allList = array_map(
            function ($list) {
                return (object) [
                    'value' => $list['id'],
                    'label' => $list['name'],
                ];
            },
            $mailPoetApi->getLists()
        );

        return Response::success($allList);
    }

    public function getSubscriberFields()
    {
        if (!class_exists(API::class)) {
            // translators: %s: Plugin name
            return Response::error(\sprintf(__('%s is not installed or activated', 'bit-pi'), 'MailPoet'));
        }

        $mailPoetApi = API::MP('v1');

        $allField = array_map(
            function ($field) {
                return (object) [
                    'value'    => $field['id'],
                    'label'    => $field['name'],
                    'required' => !empty($field['params']['required']) ? true : false,
                ];
            },
            $mailPoetApi->getSubscriberFields()
        );

        return Response::success($allField);
    }
}
