<?php

namespace BitApps\PiPro\src\Integrations\MetForm;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}


use BitApps\PiPro\Deps\BitApps\WPKit\Http\Response;

class MetFormHelper
{
    public function getForms()
    {
        if (!$this->isPluginActive()) {
            return Response::error('Met Form is not installed or activated');
        }

        $args = [
            'posts_per_page' => -1,
            'post_type'      => 'metform-form',
            'post_status'    => 'publish',
        ];

        $allForms[] = [
            'label' => 'Any form',
            'value' => 'any'
        ];

        $forms = get_posts($args);

        if ($forms) {
            foreach ($forms as $form) {
                $allForms[] = (object) [
                    'value' => $form->ID,
                    'label' => $form->post_title,
                ];
            }
        }

        return Response::success($allForms);
    }

    private function isPluginActive()
    {
        if (is_plugin_active('metform-pro/metform-pro.php')) {
            return true;
        }

        return (bool) (is_plugin_active('metform/metform.php'));
    }
}
