<?php

namespace BitApps\PiPro\src\Integrations\NewUserApprove;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class NewUserApproveHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'userApproved' => [
                'hook'          => 'new_user_approve_user_approved',
                'callback'      => [NewUserApproveTrigger::class, 'userApproved'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'userDenied' => [
                'hook'          => 'new_user_approve_user_denied',
                'callback'      => [NewUserApproveTrigger::class, 'userDenied'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'userStatusUpdated' => [
                'hook'          => 'new_user_approve_user_status_update',
                'callback'      => [NewUserApproveTrigger::class, 'userStatusUpdated'],
                'priority'      => 20,
                'accepted_args' => 2,
            ],
            'userStatusSetToApprove' => [
                'hook'          => 'new_user_approve_approve_user',
                'callback'      => [NewUserApproveTrigger::class, 'userStatusSetToApprove'],
                'priority'      => 20,
                'accepted_args' => 1,
            ],
            'userStatusSetToDeny' => [
                'hook'          => 'new_user_approve_deny_user',
                'callback'      => [NewUserApproveTrigger::class, 'userStatusSetToDeny'],
                'priority'      => 20,
                'accepted_args' => 1,
            ]
        ];
    }
}
