<?php

namespace BitApps\PiPro\src\Integrations\NewUserApprove;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class NewUserApproveTrigger
{
    public static function userApproved($userData)
    {
        return self::execute($userData, 'userApproved');
    }

    public static function userDenied($userData)
    {
        return self::execute($userData, 'userDenied');
    }

    public static function userStatusUpdated($userId, $status)
    {
        $userInfo = Utility::getUserInfo($userId);

        $userInfo['status'] = $status;

        return self::execute($userInfo, 'userStatusUpdated');
    }

    public static function userStatusSetToApprove($userId)
    {
        return self::execute(Utility::getUserInfo($userId), 'userStatusSetToApprove');
    }

    public static function userStatusSetToDeny($userId)
    {
        return self::execute(Utility::getUserInfo($userId), 'userStatusSetToDeny');
    }

    private static function execute($formData, $machineSlug)
    {
        $flows = FlowService::exists('newUserApprove', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $formData);
    }

    // TODO:: need to implement
    private static function isPluginInstalled()
    {
        return class_exists('PW_New_User_Approve');
    }
}
