<?php

namespace BitApps\PiPro\src\Integrations\Newsletter;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class NewsletterHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'subscriptionFormSubmitted' => [
                'hook'     => 'newsletter_user_post_subscribe',
                'callback' => [NewsletterTrigger::class, 'subscriptionFormSubmitted'],
            ],
            'userConfirmed' => [
                'hook'     => 'newsletter_user_confirmed',
                'callback' => [NewsletterTrigger::class, 'userConfirmed'],
            ],
            'userUnsubscribed' => [
                'hook'     => 'newsletter_user_unsubscribed',
                'callback' => [NewsletterTrigger::class, 'userUnsubscribed'],
            ],
            'userReactivated' => [
                'hook'     => 'newsletter_user_reactivated',
                'callback' => [NewsletterTrigger::class, 'userReactivated'],
            ],
            'newsletterSendEnd' => [
                'hook'     => 'newsletter_send_end',
                'callback' => [NewsletterTrigger::class, 'newsletterSendEnd'],
            ]
        ];
    }
}
