<?php

namespace BitApps\PiPro\src\Integrations\PaidMembershipPro;

use BitApps\Pi\Helpers\Utility;
use BitApps\Pi\src\Flow\NodeInfoProvider;
use BitApps\Pi\src\Interfaces\ActionInterface;

if (!\defined('ABSPATH')) {
    exit;
}


class PaidMembershipProAction implements ActionInterface
{
    private $nodeInfoProvider;

    public function __construct(NodeInfoProvider $nodeInfoProvider)
    {
        $this->nodeInfoProvider = $nodeInfoProvider;
    }

    public function execute(): array
    {
        $executedNodeAction = $this->executePaidMembershipProAction();

        return Utility::formatResponseData(
            $executedNodeAction['status_code'] ?? 200,
            $executedNodeAction['payload'] ?? [],
            $executedNodeAction['response'] ?? []
        );
    }

    private function executePaidMembershipProAction()
    {
        $machineSlug = $this->nodeInfoProvider->getMachineSlug();

        $paidMembershipProService = new PaidMembershipProServices($this->nodeInfoProvider);

        switch ($machineSlug) {
            case 'getAllMembershipLevel':
                return $paidMembershipProService->getAllMembershipLevel();

                break;

            case 'getMembershipLevel':
                return $paidMembershipProService->getMembershipLevel();

                break;

            case 'addUserToMembershipLevel':
                return $paidMembershipProService->addUserToMembershipLevel();

                break;

            case 'removeUserFromMembershipLevel':
                return $paidMembershipProService->removeUserFromMembershipLevel();

                break;

            default:
                return [
                    'response'    => __('No valid action found', 'bit-pi'),
                    'payload'     => [],
                    'status_code' => 400
                ];

                break;
        }
    }
}
