<?php

namespace BitApps\PiPro\src\Integrations\StoreEngine;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class StoreEngineHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'productPurchased' => [
                'hook'          => 'storeengine/checkout/after_place_order',
                'callback'      => [StoreEngineTrigger::class, 'productPurchased'],
                'priority'      => 10,
                'accepted_args' => 2,

            ],
            'orderStatusUpdated' => [
                'hook'          => 'storeengine/order/status_changed',
                'callback'      => [StoreEngineTrigger::class, 'orderStatusUpdated'],
                'priority'      => 10,
                'accepted_args' => 4,

            ],
            'onHoldOrder' => [
                'hook'          => 'storeengine/order_status_on_hold',
                'callback'      => [StoreEngineTrigger::class, 'onHoldOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'pendingPaymentOrder' => [
                'hook'          => 'storeengine/order_status_pending_payment',
                'callback'      => [StoreEngineTrigger::class, 'pendingPaymentOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'processingOrder' => [
                'hook'          => 'storeengine/order_status_processing',
                'callback'      => [StoreEngineTrigger::class, 'processingOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'completedOrder' => [
                'hook'          => 'storeengine/order_status_completed',
                'callback'      => [StoreEngineTrigger::class, 'completedOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'cancelledOrder' => [
                'hook'          => 'storeengine/order_status_cancelled',
                'callback'      => [StoreEngineTrigger::class, 'cancelledOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'draftOrder' => [
                'hook'          => 'storeengine/order_status_auto-draft',
                'callback'      => [StoreEngineTrigger::class, 'draftOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'trashOrder' => [
                'hook'          => 'storeengine/order_status_trash',
                'callback'      => [StoreEngineTrigger::class, 'trashOrder'],
                'priority'      => 10,
                'accepted_args' => 3,

            ],
            'customerNoteAdded' => [
                'hook'          => 'storeengine/order/new_customer_note',
                'callback'      => [StoreEngineTrigger::class, 'customerNoteAdded'],
                'priority'      => 10,
                'accepted_args' => 2,

            ],
            'customerNoteDeleted' => [
                'hook'          => 'storeengine/order/note_deleted',
                'callback'      => [StoreEngineTrigger::class, 'customerNoteDeleted'],
                'priority'      => 10,
                'accepted_args' => 2,

            ],
            'orderRestored' => [
                'hook'          => 'storeengine/order/status_changed',
                'callback'      => [StoreEngineTrigger::class, 'orderRestored'],
                'priority'      => 10,
                'accepted_args' => 4,

            ]
        ];
    }
}
