<?php

namespace BitApps\PiPro\src\Integrations\StoreEngine;

// Prevent direct script access
if (!\defined('ABSPATH')) {
    exit;
}

use BitApps\Pi\Services\FlowService;
use BitApps\PiPro\src\Integrations\IntegrationHelper;

final class StoreEngineTrigger
{
    public static function productPurchased($order, $payload)
    {
        $orderId = $order->get_id();

        $data = StoreEngineHelper::formatOrderData($orderId, $order, [], ['payload' => $payload]);

        return self::execute('productPurchased', $data);
    }

    public static function orderStatusUpdated($orderId, $oldStatus, $newStatus, $order)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, [], ['old_status' => $oldStatus, 'new_status' => $newStatus]);

        return self::execute('orderStatusUpdated', $data);
    }

    public static function onHoldOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('onHoldOrder', $data);
    }

    public static function pendingPaymentOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('pendingPaymentOrder', $data);
    }

    public static function processingOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('processingOrder', $data);
    }

    public static function completedOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('completedOrder', $data);
    }

    public static function cancelledOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('cancelledOrder', $data);
    }

    public static function draftOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('draftOrder', $data);
    }

    public static function trashOrder($orderId, $order, $statusTransition)
    {
        $data = StoreEngineHelper::formatOrderData($orderId, $order, $statusTransition);

        return self::execute('trashOrder', $data);
    }

    public static function customerNoteAdded($note, $order)
    {
        $orderId = $order->get_id();

        $data = StoreEngineHelper::formatOrderData($orderId, $order, [], ['note' => $note]);

        return self::execute('customerNoteAdded', $data);
    }

    public static function customerNoteDeleted($noteId, $note)
    {
        return self::execute('customerNoteDeleted', (array) $note);
    }

    public static function orderRestored($orderId, $oldStatus, $newStatus, $order)
    {
        if ($oldStatus !== 'trash' || $newStatus === 'trash') {
            return;
        }

        $data = StoreEngineHelper::formatOrderData($orderId, $order, [], ['old_status' => $oldStatus, 'new_status' => $newStatus]);

        return self::execute('orderRestored', $data);
    }

    private static function execute($machineSlug, $data)
    {
        $flows = FlowService::exists('StoreEngine', $machineSlug);

        if (!$flows) {
            return;
        }

        IntegrationHelper::handleFlowForForm($flows, $data);
    }

    private static function isPluginInstalled()
    {
        return \defined('STOREENGINE_VERSION');
    }
}
