<?php

namespace BitApps\PiPro\src\Integrations\WPSubscription;

use BitApps\Pi\src\Integrations\HookRegisterInterface;

if (!\defined('ABSPATH')) {
    exit;
}

class WPSubscriptionHooks implements HookRegisterInterface
{
    public function register(): array
    {
        return [
            'subscriptionActivated' => [
                'hook'     => 'subscrpt_subscription_activated',
                'callback' => [WPSubscriptionTrigger::class, 'subscriptionActivated'],
                'priority' => 10,
            ],
            'subscriptionCancelled' => [
                'hook'     => 'subscrpt_subscription_cancelled_email_notification',
                'callback' => [WPSubscriptionTrigger::class, 'subscriptionCancelled'],
                'priority' => 10,
            ],
            'subscriptionExpired' => [
                'hook'     => 'subscrpt_subscription_expired',
                'callback' => [WPSubscriptionTrigger::class, 'subscriptionExpired'],
                'priority' => 10,
            ],
            'subscriptionStatusChanged' => [
                'hook'          => 'subscrpt_status_changed_admin_email_notification',
                'callback'      => [WPSubscriptionTrigger::class, 'subscriptionStatusChanged'],
                'priority'      => 10,
                'accepted_args' => 3,
            ],
        ];
    }
}
